/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.http.CHttp;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IWriteToStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.http.EHttpVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class AS2HttpResponseHandlerSocket
implements IAS2HttpResponseHandler {
    private final Socket m_aSocket;
    private final boolean m_bQuoteHeaderValues;

    public AS2HttpResponseHandlerSocket(@Nonnull Socket socket, boolean bl) {
        this.m_aSocket = (Socket)ValueEnforcer.notNull((Object)socket, (String)"Socket");
        this.m_bQuoteHeaderValues = bl;
    }

    @Nonnull
    public final Socket getSocket() {
        return this.m_aSocket;
    }

    public final boolean isQuoteHeaderHeaderValues() {
        return this.m_bQuoteHeaderValues;
    }

    @Nonnull
    @OverrideOnDemand
    public EHttpVersion getHTTPVersion() {
        return EHttpVersion.HTTP_11;
    }

    @Nonnull
    @OverrideOnDemand
    public OutputStream createOutputStream() throws IOException {
        return StreamHelper.getBuffered((OutputStream)this.m_aSocket.getOutputStream());
    }

    @Override
    public void sendHttpResponse(@Nonnegative int n, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull @WillNotClose IWriteToStream iWriteToStream) throws IOException {
        ValueEnforcer.isGT0((int)n, (String)"HttpResponseCode");
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"Headers");
        ValueEnforcer.notNull((Object)iWriteToStream, (String)"Data");
        try (OutputStream outputStream = this.createOutputStream();){
            String string = this.getHTTPVersion().getName() + " " + Integer.toString(n) + " " + CHttp.getHttpResponseMessage((int)n) + "\r\n";
            outputStream.write(string.getBytes(CHttp.HTTP_CHARSET));
            for (String string2 : httpHeaderMap.getAllHeaderLines(true, this.m_bQuoteHeaderValues)) {
                outputStream.write((string2 + "\r\n").getBytes(CHttp.HTTP_CHARSET));
            }
            outputStream.write("\r\n".getBytes(CHttp.HTTP_CHARSET));
            iWriteToStream.writeTo(outputStream);
            outputStream.flush();
        }
    }
}

