/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.cert;

import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.partner.Partnership;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS2CertificateNotFoundException
extends AS2Exception {
    private final ECertificatePartnershipType m_ePartnershipType;
    private final String m_sAlias;

    public AS2CertificateNotFoundException(@Nullable ECertificatePartnershipType eCertificatePartnershipType, @Nonnull Partnership partnership) {
        super("Type " + eCertificatePartnershipType + ": no alias found for partnership " + partnership);
        this.m_ePartnershipType = eCertificatePartnershipType;
        this.m_sAlias = null;
    }

    public AS2CertificateNotFoundException(@Nullable ECertificatePartnershipType eCertificatePartnershipType, @Nullable String string) {
        super("Type " + eCertificatePartnershipType + ": no such alias '" + string + "'");
        this.m_ePartnershipType = eCertificatePartnershipType;
        this.m_sAlias = string;
    }

    public AS2CertificateNotFoundException(@Nullable X509Certificate x509Certificate) {
        super("Certificate not in store '" + x509Certificate + "'");
        this.m_ePartnershipType = null;
        this.m_sAlias = null;
    }

    @Nullable
    public ECertificatePartnershipType getPartnershipType() {
        return this.m_ePartnershipType;
    }

    @Nullable
    public String getAlias() {
        return this.m_sAlias;
    }
}

