/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.sender;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.processor.sender.AbstractSenderModule;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.dump.DefaultHTTPOutgoingDumperFactory;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumper;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumperFactory;
import com.helger.as2lib.util.http.AS2HttpClient;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2OutgoingHttpCallback;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.url.EURLProtocol;
import com.helger.commons.ws.HostnameVerifierVerifyAll;
import com.helger.commons.ws.TrustManagerTrustAll;
import java.io.File;
import java.net.Proxy;
import java.security.GeneralSecurityException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpSenderModule
extends AbstractSenderModule {
    public static final String ATTR_CONNECT_TIMEOUT = "connecttimeout";
    public static final String ATTR_RESPONSE_TIMEOUT = "responsetimeout";
    public static final String ATTR_QUOTE_HEADER_VALUES = "quoteheadervalues";
    public static final Timeout DEFAULT_CONNECT_TIMEOUT = Timeout.ofSeconds((long)60L);
    public static final Timeout DEFAULT_RESPONSE_TIMEOUT = Timeout.ofSeconds((long)60L);
    public static final boolean DEFAULT_QUOTE_HEADER_VALUES = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpSenderModule.class);
    private static final IHTTPOutgoingDumperFactory DEFAULT_HTTP_OUTGOING_DUMPER_FACTORY;
    private IHTTPOutgoingDumperFactory m_aHttpOutgoingDumperFactory = DEFAULT_HTTP_OUTGOING_DUMPER_FACTORY;
    private IHTTPIncomingDumper m_aHttpIncomingDumper;
    private IAS2OutgoingHttpCallback m_aOugoingHttpCallback;

    protected AbstractHttpSenderModule() {
    }

    @Nullable
    public final IHTTPOutgoingDumperFactory getHttpOutgoingDumperFactory() {
        return this.m_aHttpOutgoingDumperFactory;
    }

    @Nullable
    public final IHTTPOutgoingDumper getHttpOutgoingDumper(@Nonnull IBaseMessage iBaseMessage) {
        return this.m_aHttpOutgoingDumperFactory == null ? null : (IHTTPOutgoingDumper)this.m_aHttpOutgoingDumperFactory.apply(iBaseMessage);
    }

    public final void setHttpOutgoingDumperFactory(@Nullable IHTTPOutgoingDumperFactory iHTTPOutgoingDumperFactory) {
        this.m_aHttpOutgoingDumperFactory = iHTTPOutgoingDumperFactory;
    }

    @Nullable
    public final IHTTPIncomingDumper getHttpIncomingDumper() {
        return this.m_aHttpIncomingDumper;
    }

    @Nullable
    public final IHTTPIncomingDumper getEffectiveHttpIncomingDumper() {
        IHTTPIncomingDumper iHTTPIncomingDumper = this.m_aHttpIncomingDumper;
        if (iHTTPIncomingDumper == null) {
            iHTTPIncomingDumper = HTTPHelper.getHTTPIncomingDumper();
        }
        return iHTTPIncomingDumper;
    }

    public final void setHttpIncomingDumper(@Nullable IHTTPIncomingDumper iHTTPIncomingDumper) {
        this.m_aHttpIncomingDumper = iHTTPIncomingDumper;
    }

    @Nullable
    public final IAS2OutgoingHttpCallback getOutgoingHttpCallback() {
        return this.m_aOugoingHttpCallback;
    }

    public final void setOutgoingHttpCallback(@Nullable IAS2OutgoingHttpCallback iAS2OutgoingHttpCallback) {
        this.m_aOugoingHttpCallback = iAS2OutgoingHttpCallback;
    }

    @Nonnull
    public final Timeout getConnectTimeout() {
        long l = this.attrs().getAsLong((Object)ATTR_CONNECT_TIMEOUT, -1L);
        if (l >= 0L) {
            return Timeout.ofMilliseconds((long)l);
        }
        return DEFAULT_CONNECT_TIMEOUT;
    }

    public final void setConnectTimeoutMilliseconds(long l) {
        if (l < 0L) {
            this.attrs().remove((Object)ATTR_CONNECT_TIMEOUT);
        } else {
            this.attrs().putIn(ATTR_CONNECT_TIMEOUT, l);
        }
    }

    @Nonnull
    public final Timeout getResponseTimeout() {
        long l = this.attrs().getAsLong((Object)ATTR_RESPONSE_TIMEOUT, -1L);
        if (l >= 0L) {
            return Timeout.ofMilliseconds((long)l);
        }
        return DEFAULT_RESPONSE_TIMEOUT;
    }

    public final void setResponseTimeoutMilliseconds(long l) {
        if (l < 0L) {
            this.attrs().remove((Object)ATTR_RESPONSE_TIMEOUT);
        } else {
            this.attrs().putIn(ATTR_RESPONSE_TIMEOUT, l);
        }
    }

    public final boolean isQuoteHeaderValues() {
        return this.attrs().getAsBoolean((Object)ATTR_QUOTE_HEADER_VALUES, false);
    }

    public final void setQuoteHeaderValues(boolean bl) {
        this.attrs().putIn(ATTR_QUOTE_HEADER_VALUES, bl);
    }

    @Nonnull
    @OverrideOnDemand
    public SSLContext createSSLContext() throws GeneralSecurityException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, new TrustManager[]{new TrustManagerTrustAll(false)}, null);
        return sSLContext;
    }

    @Nullable
    @OverrideOnDemand
    public HostnameVerifier createHostnameVerifier() {
        return new HostnameVerifierVerifyAll();
    }

    @OverrideOnDemand
    public boolean isUseSSL(@Nonnull @Nonempty String string) {
        return EURLProtocol.HTTPS.isUsedInURL(string.toLowerCase(Locale.ROOT));
    }

    @Nonnull
    public AS2HttpClient getHttpClient(@Nonnull @Nonempty String string, @Nonnull EHttpMethod eHttpMethod, @Nullable Proxy proxy) throws AS2Exception {
        HostnameVerifier hostnameVerifier;
        SSLContext sSLContext;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URL");
        if (this.isUseSSL(string)) {
            try {
                sSLContext = this.createSSLContext();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new AS2Exception("Error creating SSL Context", generalSecurityException);
            }
            hostnameVerifier = this.createHostnameVerifier();
        } else {
            sSLContext = null;
            hostnameVerifier = null;
        }
        Timeout timeout = this.getConnectTimeout();
        Timeout timeout2 = this.getResponseTimeout();
        return new AS2HttpClient(string, timeout, timeout2, eHttpMethod, proxy, sSLContext, hostnameVerifier);
    }

    static {
        String string = SystemProperties.getPropertyValueOrNull((String)"AS2.httpDumpDirectoryOutgoing");
        if (StringHelper.hasText((String)string)) {
            LOGGER.info("Using '" + string + "' as the global directory to dump outgoing messages (source: system property)");
            File file = new File(string);
            AS2IOHelper.getFileOperationManager().createDirIfNotExisting(file);
            DEFAULT_HTTP_OUTGOING_DUMPER_FACTORY = new DefaultHTTPOutgoingDumperFactory(file);
        } else {
            DEFAULT_HTTP_OUTGOING_DUMPER_FACTORY = null;
        }
    }
}

