/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.javamail;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DispositionDataContentHandler
implements DataContentHandler {
    private static final ActivationDataFlavor ADF1 = new ActivationDataFlavor(MimeBodyPart.class, "message/disposition-notification", "Disposition Notification");
    private static final ActivationDataFlavor[] ADFS = new ActivationDataFlavor[]{ADF1};

    @Nullable
    public byte[] getContent(@Nonnull DataSource dataSource) throws IOException {
        return StreamHelper.getAllBytes((InputStream)StreamHelper.getBuffered((InputStream)dataSource.getInputStream()));
    }

    @Nullable
    public byte[] getTransferData(ActivationDataFlavor activationDataFlavor, @Nonnull DataSource dataSource) throws IOException {
        if (ADF1.equals(activationDataFlavor)) {
            return this.getContent(dataSource);
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ActivationDataFlavor[] getTransferDataFlavors() {
        return (ActivationDataFlavor[])ArrayHelper.getCopy((Object[])ADFS);
    }

    @Nullable
    private static Charset _getCharset(@Nullable String string) {
        try {
            String string2;
            MimeType mimeType = MimeTypeParser.parseMimeType((String)string);
            if (mimeType != null && (string2 = mimeType.getParameterValueWithName("charset")) != null) {
                return Charset.forName(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void writeTo(Object object, String string, @Nonnull OutputStream outputStream) throws IOException {
        if (object instanceof MimeBodyPart) {
            try {
                ((MimeBodyPart)object).writeTo(outputStream);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException);
            }
        } else if (object instanceof MimeMultipart) {
            try {
                ((MimeMultipart)object).writeTo(outputStream);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException);
            }
        } else if (object instanceof byte[]) {
            outputStream.write((byte[])object);
        } else if (object instanceof String) {
            Charset charset = DispositionDataContentHandler._getCharset(string);
            if (charset != null) {
                outputStream.write(((String)object).getBytes(charset));
            } else {
                outputStream.write(((String)object).getBytes());
            }
        } else {
            throw new IOException("Unknown object type: " + object.getClass().getName());
        }
    }
}

