/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.disposition;

import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DispositionOptions {
    public static final String SIGNED_RECEIPT_PROTOCOL = "signed-receipt-protocol";
    public static final String SIGNED_RECEIPT_MICALG = "signed-receipt-micalg";
    public static final String IMPORTANCE_REQUIRED = "required";
    public static final String IMPORTANCE_OPTIONAL = "optional";
    public static final String PROTOCOL_PKCS7_SIGNATURE = "pkcs7-signature";
    private static final Logger LOGGER = LoggerFactory.getLogger(DispositionOptions.class);
    private String m_sProtocolImportance;
    private String m_sProtocol;
    private String m_sMICAlgImportance;
    private final ICommonsList<ECryptoAlgorithmSign> m_aMICAlgs = new CommonsArrayList();

    private static void _checkImportance(@Nullable String string) {
        if (string != null && !string.equals(IMPORTANCE_REQUIRED) && !string.equals(IMPORTANCE_OPTIONAL)) {
            LOGGER.warn("Non-standard importance value '" + string + "' used!");
        }
    }

    @Nonnull
    public DispositionOptions setProtocolImportance(@Nullable String string) {
        DispositionOptions._checkImportance(string);
        this.m_sProtocolImportance = string;
        return this;
    }

    @Nullable
    public String getProtocolImportance() {
        return this.m_sProtocolImportance;
    }

    public boolean isProtocolRequired() {
        return IMPORTANCE_REQUIRED.equals(this.m_sProtocolImportance);
    }

    public boolean isProtocolOptional() {
        return IMPORTANCE_OPTIONAL.equals(this.m_sProtocolImportance);
    }

    @Nonnull
    public DispositionOptions setProtocol(@Nullable String string) {
        this.m_sProtocol = string;
        return this;
    }

    @Nullable
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Nonnull
    public DispositionOptions setMICAlgImportance(@Nullable String string) {
        DispositionOptions._checkImportance(string);
        this.m_sMICAlgImportance = string;
        return this;
    }

    @Nullable
    public String getMICAlgImportance() {
        return this.m_sMICAlgImportance;
    }

    public boolean isMICAlgRequired() {
        return IMPORTANCE_REQUIRED.equals(this.m_sMICAlgImportance);
    }

    public boolean isMICAlgOptional() {
        return IMPORTANCE_OPTIONAL.equals(this.m_sMICAlgImportance);
    }

    @Nonnull
    public DispositionOptions setMICAlg(@Nullable String string) {
        this.m_aMICAlgs.clear();
        if (StringHelper.hasText((String)string)) {
            ICommonsList iCommonsList = StringHelper.getExploded((char)',', (String)string.trim());
            for (String string2 : iCommonsList) {
                String string3 = string2.trim();
                ECryptoAlgorithmSign eCryptoAlgorithmSign = ECryptoAlgorithmSign.getFromIDOrNull(string3);
                if (eCryptoAlgorithmSign == null) {
                    LOGGER.warn("The passed MIC algorithm '" + string3 + "' is unsupported!");
                    continue;
                }
                this.m_aMICAlgs.add((Object)eCryptoAlgorithmSign);
            }
        }
        return this;
    }

    @Nonnull
    public DispositionOptions setMICAlg(ECryptoAlgorithmSign ... eCryptoAlgorithmSignArray) {
        this.m_aMICAlgs.clear();
        if (eCryptoAlgorithmSignArray != null) {
            for (ECryptoAlgorithmSign eCryptoAlgorithmSign : eCryptoAlgorithmSignArray) {
                if (eCryptoAlgorithmSign == null) continue;
                this.m_aMICAlgs.add((Object)eCryptoAlgorithmSign);
            }
        }
        return this;
    }

    @Nonnull
    public DispositionOptions setMICAlg(@Nullable Iterable<? extends ECryptoAlgorithmSign> iterable) {
        this.m_aMICAlgs.clear();
        if (iterable != null) {
            for (ECryptoAlgorithmSign eCryptoAlgorithmSign : iterable) {
                if (eCryptoAlgorithmSign == null) continue;
                this.m_aMICAlgs.add((Object)eCryptoAlgorithmSign);
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ECryptoAlgorithmSign> getAllMICAlgs() {
        return (ICommonsList)this.m_aMICAlgs.getClone();
    }

    @Nullable
    public ECryptoAlgorithmSign getFirstMICAlg() {
        return (ECryptoAlgorithmSign)this.m_aMICAlgs.getFirstOrNull();
    }

    @Nonnegative
    public int getMICAlgCount() {
        return this.m_aMICAlgs.size();
    }

    public boolean hasMICAlg() {
        return this.m_aMICAlgs.isNotEmpty();
    }

    @Nullable
    public String getMICAlgAsString() {
        if (this.m_aMICAlgs.isEmpty()) {
            return null;
        }
        return StringHelper.getImplodedMapped((String)", ", this.m_aMICAlgs, ECryptoAlgorithmSign::getID);
    }

    @Nonnull
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText((String)this.m_sProtocolImportance) && StringHelper.hasText((String)this.m_sProtocol)) {
            stringBuilder.append(SIGNED_RECEIPT_PROTOCOL).append('=').append(this.m_sProtocolImportance).append(", ").append(this.m_sProtocol);
        }
        if (StringHelper.hasText((String)this.m_sMICAlgImportance) && !this.m_aMICAlgs.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(SIGNED_RECEIPT_MICALG).append('=').append(this.m_sMICAlgImportance).append(", ").append(this.getMICAlgAsString());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ProtocolImportance", (Object)this.m_sProtocolImportance).append("Protocol", (Object)this.m_sProtocol).append("MICAlgImportance", (Object)this.m_sMICAlgImportance).append("MICAlgs", this.m_aMICAlgs).getToString();
    }

    @Nonnull
    public static DispositionOptions createFromString(@Nullable String string) throws AS2Exception {
        DispositionOptions dispositionOptions = new DispositionOptions();
        if (StringHelper.hasTextAfterTrim((String)string)) {
            try {
                for (String string2 : StringHelper.getExplodedArray((char)';', (String)string.trim())) {
                    String[] stringArray = StringHelper.getExplodedArray((char)'=', (String)string2.trim(), (int)2);
                    if (stringArray.length == 2) {
                        String string3 = stringArray[0].trim();
                        String[] stringArray2 = StringHelper.getExplodedArray((char)',', (String)stringArray[1].trim(), (int)2);
                        if (stringArray2.length == 2) {
                            if (string3.equalsIgnoreCase(SIGNED_RECEIPT_PROTOCOL)) {
                                dispositionOptions.setProtocolImportance(stringArray2[0].trim());
                                dispositionOptions.setProtocol(stringArray2[1].trim());
                                continue;
                            }
                            if (string3.equalsIgnoreCase(SIGNED_RECEIPT_MICALG)) {
                                dispositionOptions.setMICAlgImportance(stringArray2[0].trim());
                                dispositionOptions.setMICAlg(stringArray2[1].trim());
                                continue;
                            }
                            LOGGER.warn("Unsupported disposition attribute '" + string3 + "' with value '" + stringArray[1].trim() + "' found!");
                            continue;
                        }
                        LOGGER.warn("Failed to split disposition options parameter '" + string2 + "' value '" + stringArray[1].trim() + "' into importance and values");
                        continue;
                    }
                    LOGGER.warn("Failed to split disposition options parameter '" + string2 + "' into attribute and values");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new AS2Exception("Invalid disposition options format: " + string);
            }
        }
        return dispositionOptions;
    }
}

