/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.params;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractParameterParser.class);

    public abstract void setParameter(@Nonnull String var1, @Nonnull String var2) throws AS2InvalidParameterException;

    @Nullable
    public abstract String getParameter(@Nonnull String var1) throws AS2InvalidParameterException;

    public void setParameters(@Nonnull String string) throws AS2InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=,", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new AS2InvalidParameterException("Invalid value", this, string2, null);
            }
            String string3 = stringTokenizer.nextToken();
            this.setParameter(string2, string3);
        }
    }

    public void setParameters(@Nullable String string, @Nullable String string2, @Nonnull String string3) throws AS2Exception {
        ICommonsList iCommonsList = StringHelper.getExploded((char)',', (String)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2, false);
        for (String string4 : iCommonsList) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new AS2Exception("Invalid value: Format=" + string + ", value=" + string3);
            }
            if (string4.length() <= 0) continue;
            this.setParameter(string4, stringTokenizer.nextToken());
        }
    }

    @Nonnull
    public String format(@Nullable String string) throws AS2InvalidParameterException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Formatting '" + string + "'");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                int n = i;
                if ((i = string.indexOf(36, n)) < 0) {
                    stringBuilder.append(string.substring(n, string.length()));
                    break;
                }
                if (i > n) {
                    stringBuilder.append(string.substring(n, i));
                }
                if ((i = string.indexOf(36, n = i + 1)) < 0) {
                    throw new AS2InvalidParameterException("Invalid key (missing closing $)");
                }
                if (i == n) {
                    stringBuilder.append('$');
                    continue;
                }
                String string2 = string.substring(n, i);
                stringBuilder.append(this.getParameter(string2));
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Formatted value is now '" + stringBuilder.toString() + "'");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

