/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.partner;

import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.partner.AS2PartnershipNotFoundException;
import com.helger.as2lib.partner.AbstractPartnershipFactory;
import com.helger.as2lib.partner.Partnership;
import com.helger.commons.annotation.OverrideOnDemand;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public class SelfFillingPartnershipFactory
extends AbstractPartnershipFactory {
    public static void ensureUsablePartnership(@Nonnull Partnership partnership) {
        if (!partnership.containsSenderX509Alias()) {
            partnership.setSenderX509Alias(partnership.getSenderAS2ID());
        }
        if (!partnership.containsReceiverX509Alias()) {
            partnership.setReceiverX509Alias(partnership.getReceiverAS2ID());
        }
        if ("auto-created-dummy".equals(partnership.getName())) {
            partnership.setName(partnership.getSenderAS2ID() + "-" + partnership.getReceiverAS2ID());
        }
        if (partnership.getSigningAlgorithm() == null) {
            partnership.setSigningAlgorithm(ECryptoAlgorithmSign.DIGEST_SHA_1);
        }
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void onBeforeAddPartnership(@Nonnull Partnership partnership) throws AS2Exception {
        SelfFillingPartnershipFactory.ensureUsablePartnership(partnership);
    }

    @Override
    @Nonnull
    public final Partnership getPartnership(@Nonnull Partnership partnership) throws AS2Exception {
        try {
            return super.getPartnership(partnership);
        }
        catch (AS2PartnershipNotFoundException aS2PartnershipNotFoundException) {
            this.onBeforeAddPartnership(partnership);
            this.addPartnership(partnership);
            return partnership;
        }
    }
}

