/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.partner.xml;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.partner.AbstractPartnershipFactory;
import com.helger.as2lib.partner.xml.IPartnerMap;
import com.helger.as2lib.partner.xml.IPartnershipFactoryWithPartners;
import com.helger.as2lib.partner.xml.Partner;
import com.helger.as2lib.partner.xml.PartnerMap;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.state.EChange;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractPartnershipFactoryWithPartners
extends AbstractPartnershipFactory
implements IPartnershipFactoryWithPartners {
    private final PartnerMap m_aPartners = new PartnerMap();

    protected final void setPartners(@Nonnull PartnerMap partnerMap) throws AS2Exception {
        this.m_aRWLock.writeLockedThrowing(() -> {
            this.m_aPartners.setPartners(partnerMap);
            this.markAsChanged();
        });
    }

    @Override
    public void addPartner(@Nonnull Partner partner) throws AS2Exception {
        this.m_aRWLock.writeLockedThrowing(() -> {
            this.m_aPartners.addPartner(partner);
            this.markAsChanged();
        });
    }

    @Override
    @Nonnull
    public EChange removePartner(@Nullable String string) throws AS2Exception {
        return (EChange)this.m_aRWLock.writeLockedGetThrowing(() -> {
            if (this.m_aPartners.removePartner(string).isUnchanged()) {
                return EChange.UNCHANGED;
            }
            this.markAsChanged();
            return EChange.CHANGED;
        });
    }

    @Override
    @Nullable
    public Partner getPartnerOfName(@Nullable String string) {
        return (Partner)this.m_aRWLock.readLockedGet(() -> this.m_aPartners.getPartnerOfName(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllPartnerNames() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(this.m_aPartners::getAllPartnerNames);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Partner> getAllPartners() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(this.m_aPartners::getAllPartners);
    }

    @Nonnull
    public IPartnerMap getPartnerMap() {
        return (IPartnerMap)this.m_aRWLock.readLockedGet(() -> this.m_aPartners);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

