/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.AS2NoModuleException;
import com.helger.as2lib.processor.AbstractMessageProcessor;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.exception.IExceptionCallback;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AsyncMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMessageProcessor.class);
    private final BlockingQueue<HandleObject> m_aQueue = new LinkedBlockingQueue<HandleObject>();
    private final CallbackList<IExceptionCallback<Throwable>> m_aExceptionCallbacks = new CallbackList();
    private final Thread m_aProcessorThread;

    public AsyncMessageProcessor() {
        Runnable runnable = () -> {
            while (true) {
                try {
                    while (true) {
                        HandleObject handleObject;
                        if ((handleObject = this.m_aQueue.poll(1L, TimeUnit.SECONDS)) == null) {
                            continue;
                        }
                        this.executeAction(handleObject.m_sAction, handleObject.m_aMsg, handleObject.m_aOptions);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    LOGGER.error("Error taking elements from queue - queue has been interrupted!!!");
                }
                catch (AS2NoModuleException aS2NoModuleException) {
                    this.m_aExceptionCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)aS2NoModuleException));
                    continue;
                }
                catch (Exception exception) {
                    if (this.m_aExceptionCallbacks.isNotEmpty()) {
                        this.m_aExceptionCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)exception));
                        continue;
                    }
                    LOGGER.error("Error executing action", (Throwable)exception);
                    continue;
                }
                break;
            }
        };
        this.m_aProcessorThread = new Thread(runnable, "AS2-AsyncMessageProcessor");
        this.m_aProcessorThread.setDaemon(true);
        this.m_aProcessorThread.start();
    }

    @Nonnull
    protected final Thread getProcessortThread() {
        return this.m_aProcessorThread;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<Throwable>> exceptionCallbacks() {
        return this.m_aExceptionCallbacks;
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AsyncMessageProcessor.handle (" + string + "," + String.valueOf(iMessage) + "," + String.valueOf(map) + ")");
        }
        try {
            this.m_aQueue.put(new HandleObject(string, iMessage, map));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new AS2Exception("Failed to queue action " + string, interruptedException);
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static final class HandleObject {
        private final String m_sAction;
        private final IMessage m_aMsg;
        @CodingStyleguideUnaware
        private final Map<String, Object> m_aOptions;

        public HandleObject(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
            this.m_sAction = string;
            this.m_aMsg = iMessage;
            this.m_aOptions = map;
        }
    }
}

