/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.processor.receiver.AbstractActiveReceiverModule;
import com.helger.as2lib.session.IAS2Session;
import com.helger.commons.collection.attr.IStringMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActivePollingModule
extends AbstractActiveReceiverModule {
    public static final String ATTR_POLLING_INTERVAL = "interval";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractActivePollingModule.class);
    private Timer m_aTimer;
    private final AtomicBoolean m_aBusy = new AtomicBoolean(false);

    @Override
    @OverridingMethodsMustInvokeSuper
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        super.initDynamicComponent(iAS2Session, iStringMap);
        this.getAttributeAsStringRequired(ATTR_POLLING_INTERVAL);
    }

    public void setInterval(long l) {
        this.attrs().putIn(ATTR_POLLING_INTERVAL, l);
    }

    @CheckForSigned
    public long getInterval() {
        return this.attrs().getAsLong((Object)ATTR_POLLING_INTERVAL, 0L);
    }

    public final boolean isBusy() {
        return this.m_aBusy.get();
    }

    final boolean setBusy() {
        return this.m_aBusy.compareAndSet(false, true);
    }

    final void setNotBusy() {
        this.m_aBusy.set(false);
    }

    public abstract void poll();

    @Override
    public void doStart() throws AS2Exception {
        this.m_aTimer = new Timer(true);
        this.m_aTimer.scheduleAtFixedRate((TimerTask)new PollTask(), 0L, this.getInterval() * 1000L);
        LOGGER.info("Scheduled the polling task to run every " + this.getInterval() + " seconds");
    }

    @Override
    public void doStop() throws AS2Exception {
        if (this.m_aTimer != null) {
            LOGGER.info("Now stopping the scheduled polling task");
            this.m_aTimer.cancel();
            this.m_aTimer = null;
        }
    }

    private class PollTask
    extends TimerTask {
        private PollTask() {
        }

        @Override
        public void run() {
            if (AbstractActivePollingModule.this.setBusy()) {
                try {
                    AbstractActivePollingModule.this.poll();
                }
                finally {
                    AbstractActivePollingModule.this.setNotBusy();
                }
            } else {
                LOGGER.info("Miss tick");
            }
        }
    }
}

