/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver.net;

import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.cert.ICertificateFactory;
import com.helger.as2lib.crypto.IMICMatchingHandler;
import com.helger.as2lib.crypto.LoggingMICMatchingHandler;
import com.helger.as2lib.crypto.MIC;
import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.AS2MessageMDN;
import com.helger.as2lib.processor.AS2NoModuleException;
import com.helger.as2lib.processor.receiver.AS2MDNReceiverModule;
import com.helger.as2lib.processor.receiver.AbstractActiveNetModule;
import com.helger.as2lib.processor.receiver.net.AS2NetException;
import com.helger.as2lib.processor.receiver.net.AbstractReceiverHandler;
import com.helger.as2lib.session.AS2ComponentNotFoundException;
import com.helger.as2lib.util.AS2Helper;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.AS2HttpClient;
import com.helger.as2lib.util.http.AS2HttpRequestDataProviderInputStream;
import com.helger.as2lib.util.http.AS2HttpResponseHandlerSocket;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2lib.util.http.IAS2IncomingMDNCallback;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.timing.StopWatch;
import com.helger.mail.datasource.ByteArrayDataSource;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2MDNReceiverHandler
extends AbstractReceiverHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2MDNReceiverHandler.class);
    private final AS2MDNReceiverModule m_aReceiverModule;
    private IMICMatchingHandler m_aMICMatchingHandler = new LoggingMICMatchingHandler();
    private IAS2IncomingMDNCallback m_aIncomingMDNCallback;

    public AS2MDNReceiverHandler(@Nonnull AS2MDNReceiverModule aS2MDNReceiverModule) {
        this.m_aReceiverModule = (AS2MDNReceiverModule)ValueEnforcer.notNull((Object)aS2MDNReceiverModule, (String)"Module");
    }

    @Nonnull
    public final AS2MDNReceiverModule getModule() {
        return this.m_aReceiverModule;
    }

    @Nonnull
    public final IMICMatchingHandler getMICMatchingHandler() {
        return this.m_aMICMatchingHandler;
    }

    public final void setMICMatchingHandler(@Nonnull IMICMatchingHandler iMICMatchingHandler) {
        ValueEnforcer.notNull((Object)iMICMatchingHandler, (String)"MICMatchingHandler");
        this.m_aMICMatchingHandler = iMICMatchingHandler;
    }

    @Nullable
    public final IAS2IncomingMDNCallback getIncomingMDNCallback() {
        return this.m_aIncomingMDNCallback;
    }

    public final void setIncomingMDNCallback(@Nullable IAS2IncomingMDNCallback iAS2IncomingMDNCallback) {
        this.m_aIncomingMDNCallback = iAS2IncomingMDNCallback;
    }

    @Nullable
    protected File getPendingInfoFile(@Nonnull AS2Message aS2Message) throws AS2Exception {
        String string = aS2Message.getMDN().attrs().getAsString((Object)"ORIGINAL_MESSAGE_ID");
        String string2 = AS2IOHelper.getSafeFileAndFolderName(this.getModule().getSession().getMessageProcessor().getPendingMDNInfoFolder());
        if (StringHelper.hasNoText((String)string2)) {
            LOGGER.error("The pending MDN info folder is not properly configured. Cannot check for async MDNs.");
            return null;
        }
        return new File(string2 + FilenameHelper.UNIX_SEPARATOR_STR + AS2IOHelper.getFilenameFromMessageID(string));
    }

    @Nullable
    @OverrideOnDemand
    protected InputStream openPendingInfoStreamForReading(@Nonnull AS2Message aS2Message) throws AS2Exception {
        File file = this.getPendingInfoFile(aS2Message);
        if (file == null) {
            return null;
        }
        LOGGER.info("Trying to read original MIC and message ID information from file '" + file.getAbsolutePath() + "'" + aS2Message.getLoggingText());
        FileInputStream fileInputStream = FileHelper.getInputStream((File)file);
        if (fileInputStream == null) {
            LOGGER.error("The pending info file '" + file.getAbsolutePath() + "' with the original MIC could not be opened for reading");
        }
        return fileInputStream;
    }

    @OverrideOnDemand
    protected ESuccess deletePendingInfoStream(@Nonnull AS2Message aS2Message) throws AS2Exception {
        File file = this.getPendingInfoFile(aS2Message);
        LOGGER.info("Delete pendinginfo file '" + file.getAbsolutePath() + "'" + aS2Message.getLoggingText());
        if (!file.delete()) {
            LOGGER.error("Error delete pendinginfo file '" + file.getAbsolutePath() + "'");
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    @OverrideOnDemand
    protected ESuccess deletePendingFile(@Nonnull AS2Message aS2Message, @Nonnull String string) throws AS2Exception {
        File file = new File(string);
        LOGGER.info("Delete pending file '" + file.getAbsolutePath() + "'" + aS2Message.getLoggingText());
        if (!file.delete()) {
            LOGGER.error("Error delete pending file '" + file.getAbsolutePath() + "'");
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAsyncMDN(@Nonnull AS2Message aS2Message) throws AS2Exception {
        try {
            boolean bl;
            String string2;
            MIC mIC2;
            String string3;
            String string = aS2Message.getMDN().attrs().getAsString((Object)"MIC");
            MIC mIC = MIC.parse(string);
            try (Object object = this.openPendingInfoStreamForReading(aS2Message);){
                if (object == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)StreamHelper.createReader((InputStream)object, (Charset)StandardCharsets.ISO_8859_1));){
                    string3 = nonBlockingBufferedReader.readLine();
                    mIC2 = MIC.parse(string3);
                    string2 = nonBlockingBufferedReader.readLine();
                }
            }
            object = aS2Message.getMDN().attrs().getAsString((Object)"DISPOSITION");
            LOGGER.info("received MDN [" + (String)object + "]" + aS2Message.getLoggingText());
            boolean bl3 = bl = mIC2 != null && mIC != null && mIC.equals(mIC2);
            if (!bl) {
                LOGGER.info("MIC was not matched, so the pending file '" + string2 + "' will NOT be deleted.");
                this.m_aMICMatchingHandler.onMICMismatch(aS2Message, string3, string);
                return false;
            }
            this.m_aMICMatchingHandler.onMICMatch(aS2Message, string);
            this.deletePendingInfoStream(aS2Message);
            this.deletePendingFile(aS2Message, string2);
            return true;
        }
        catch (AS2ComponentNotFoundException | IOException exception) {
            LOGGER.error("Error checking async MDN", (Throwable)exception);
            return false;
        }
    }

    protected final void receiveMDN(@Nonnull AS2Message aS2Message, byte[] byArray, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws AS2Exception, IOException {
        try {
            AS2MessageMDN aS2MessageMDN = new AS2MessageMDN(aS2Message);
            aS2MessageMDN.headers().setAllHeaders(aS2Message.headers());
            MimeBodyPart mimeBodyPart = new MimeBodyPart(AS2HttpHelper.getAsInternetHeaders(aS2MessageMDN.headers()), byArray);
            aS2MessageMDN.setData(mimeBodyPart);
            aS2MessageMDN.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-From"));
            aS2MessageMDN.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-To"));
            aS2MessageMDN.partnership().setSenderX509Alias(aS2Message.partnership().getReceiverX509Alias());
            aS2MessageMDN.partnership().setReceiverX509Alias(aS2Message.partnership().getSenderX509Alias());
            this.getModule().getSession().getPartnershipFactory().updatePartnership(aS2MessageMDN, false);
            ICertificateFactory iCertificateFactory = this.getModule().getSession().getCertificateFactory();
            X509Certificate x509Certificate = iCertificateFactory.getCertificate(aS2MessageMDN, ECertificatePartnershipType.SENDER);
            ETriState eTriState = aS2Message.partnership().getVerifyUseCertificateInBodyPart();
            boolean bl = eTriState.isDefined() ? eTriState.getAsBooleanValue() : this.getModule().getSession().isCryptoVerifyUseCertificateInBodyPart();
            AS2Helper.parseMDN(aS2Message, x509Certificate, bl, this.getVerificationCertificateConsumer(), aS2ResourceHelper);
            aS2Message.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-To"));
            aS2Message.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-From"));
            this.getModule().getSession().getPartnershipFactory().updatePartnership(aS2Message, false);
            aS2Message.setMessageID(aS2MessageMDN.attrs().getAsString((Object)"ORIGINAL_MESSAGE_ID"));
            try {
                this.getModule().getSession().getMessageProcessor().handle("storemdn", aS2Message, null);
            }
            catch (AS2NoModuleException | AS2ComponentNotFoundException aS2Exception) {
                // empty catch block
            }
            boolean bl2 = this.checkAsyncMDN(aS2Message);
            HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, bl2 ? 200 : 404);
            String string = aS2MessageMDN.attrs().getAsString((Object)"DISPOSITION");
            if (this.m_aIncomingMDNCallback != null) {
                this.m_aIncomingMDNCallback.onIncomingMDN(false, aS2MessageMDN, aS2MessageMDN.getHeader("AS2-From"), aS2MessageMDN.getHeader("AS2-To"), string, aS2MessageMDN.attrs().getAsString((Object)"MIC"), aS2MessageMDN.attrs().getAsString((Object)"ORIGINAL_MESSAGE_ID"), aS2MessageMDN.attrs().getAsBoolean((Object)"as2msg.received.signed", false), bl2);
            }
            DispositionType.createFromString(string).validate(aS2Message, aS2MessageMDN.getText());
        }
        catch (IOException iOException) {
            HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 400);
            throw iOException;
        }
        catch (Exception exception) {
            HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 400);
            throw WrappedAS2Exception.wrap(exception).setSourceMsg(aS2Message);
        }
    }

    public void reparse(@Nonnull AS2Message aS2Message, @Nonnull AS2HttpClient aS2HttpClient, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper) throws AS2Exception {
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream;
        AS2MessageMDN aS2MessageMDN = new AS2MessageMDN(aS2Message);
        aS2MessageMDN.headers().addAllHeaders(aS2HttpClient.getResponseHeaderFields());
        byte[] byArray = null;
        try {
            nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            try {
                InputStream inputStream = aS2HttpClient.getInputStream();
                StreamHelper.CopyByteStreamBuilder copyByteStreamBuilder = StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to((OutputStream)nonBlockingByteArrayOutputStream).closeTo(false);
                long l = StringParser.parseLong((String)aS2MessageMDN.getHeader("Content-Length"), (long)-1L);
                if (l >= 0L) {
                    copyByteStreamBuilder.limit(l);
                }
                copyByteStreamBuilder.build();
                byArray = nonBlockingByteArrayOutputStream.toByteArray();
            }
            finally {
                nonBlockingByteArrayOutputStream.close();
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Error reparsing", (Throwable)iOException);
        }
        if (iHTTPIncomingDumper != null) {
            iHTTPIncomingDumper.dumpIncomingRequest((List<String>)aS2MessageMDN.headers().getAllHeaderLines(true), byArray != null ? byArray : ArrayHelper.EMPTY_BYTE_ARRAY, aS2MessageMDN);
        }
        nonBlockingByteArrayOutputStream = null;
        if (byArray != null) {
            try {
                nonBlockingByteArrayOutputStream = new MimeBodyPart(AS2HttpHelper.getAsInternetHeaders(aS2MessageMDN.headers()), byArray);
            }
            catch (MessagingException messagingException) {
                LOGGER.error("Error creating MimeBodyPart for received MDN", (Throwable)messagingException);
            }
        }
        aS2MessageMDN.setData((MimeBodyPart)nonBlockingByteArrayOutputStream);
        aS2MessageMDN.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-From"));
        aS2MessageMDN.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-To"));
    }

    public void handleIncomingMessage(@Nonnull @Nonempty String string, @Nonnull DataSource dataSource, @Nonnull AS2Message aS2Message, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler) {
        try (AS2ResourceHelper aS2ResourceHelper = new AS2ResourceHelper();){
            byte[] byArray = StreamHelper.getAllBytes((InputStream)dataSource.getInputStream());
            String string2 = AS2HttpHelper.getCleanContentType(aS2Message.getHeader("Content-Type"));
            MimeBodyPart mimeBodyPart = new MimeBodyPart(AS2HttpHelper.getAsInternetHeaders(aS2Message.headers()), byArray);
            aS2Message.setData(mimeBodyPart);
            mimeBodyPart.setDataHandler(new ByteArrayDataSource(byArray, string2, null).getAsDataHandler());
            mimeBodyPart.setHeader("Content-Type", string2);
            aS2Message.setData(mimeBodyPart);
            this.receiveMDN(aS2Message, byArray, iAS2HttpResponseHandler, aS2ResourceHelper);
            LOGGER.info("Received async MDN " + string + aS2Message.getLoggingText());
        }
        catch (Exception exception) {
            this.m_aReceiverModule.handleError(aS2Message, WrappedAS2Exception.wrap(exception));
        }
    }

    @Override
    public void handle(@Nonnull AbstractActiveNetModule abstractActiveNetModule, @Nonnull Socket socket) {
        String string = this.getClientInfo(socket);
        LOGGER.info("incoming connection for receiving AsyncMDN [" + string + "]");
        AS2Message aS2Message = new AS2Message();
        boolean bl = this.m_aReceiverModule.isQuoteHeaderValues();
        AS2HttpResponseHandlerSocket aS2HttpResponseHandlerSocket = new AS2HttpResponseHandlerSocket(socket, bl);
        StopWatch stopWatch = StopWatch.createdStarted();
        DataSource dataSource = null;
        try {
            IHTTPIncomingDumper iHTTPIncomingDumper = this.getEffectiveHttpIncomingDumper();
            dataSource = HTTPHelper.readAndDecodeHttpRequest(new AS2HttpRequestDataProviderInputStream(socket.getInputStream()), aS2HttpResponseHandlerSocket, aS2Message, iHTTPIncomingDumper);
        }
        catch (Exception exception) {
            new AS2NetException(socket.getInetAddress(), socket.getPort(), exception).terminate();
        }
        stopWatch.stop();
        if (dataSource == null) {
            LOGGER.error("Not having a data source to operate on");
        } else {
            if (dataSource instanceof ByteArrayDataSource) {
                LOGGER.info("received " + AS2IOHelper.getTransferRate(((ByteArrayDataSource)dataSource).directGetBytes().length, stopWatch) + " from " + string + aS2Message.getLoggingText());
            } else {
                LOGGER.info("received message from " + string + aS2Message.getLoggingText() + " in " + stopWatch.getMillis() + " ms");
            }
            this.handleIncomingMessage(string, dataSource, aS2Message, aS2HttpResponseHandlerSocket);
        }
    }
}

