/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.sender;

import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.cert.ICertificateFactory;
import com.helger.as2lib.crypto.ECompressionType;
import com.helger.as2lib.crypto.ECryptoAlgorithmCrypt;
import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.crypto.IMICMatchingHandler;
import com.helger.as2lib.crypto.LoggingMICMatchingHandler;
import com.helger.as2lib.crypto.MIC;
import com.helger.as2lib.disposition.AS2DispositionException;
import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.AS2MessageMDN;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.processor.AS2NoModuleException;
import com.helger.as2lib.processor.sender.AS2HttpResponseException;
import com.helger.as2lib.processor.sender.AbstractHttpSenderModule;
import com.helger.as2lib.session.AS2ComponentNotFoundException;
import com.helger.as2lib.util.AS2DateHelper;
import com.helger.as2lib.util.AS2Helper;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.as2lib.util.CAS2Header;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumper;
import com.helger.as2lib.util.http.AS2HttpClient;
import com.helger.as2lib.util.http.AS2HttpHeaderSetter;
import com.helger.as2lib.util.http.IAS2IncomingMDNCallback;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.ENewLineMode;
import com.helger.commons.timing.StopWatch;
import com.helger.mail.cte.EContentTransferEncoding;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2SenderModule
extends AbstractHttpSenderModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2SenderModule.class);
    private IMICMatchingHandler m_aMICMatchingHandler = new LoggingMICMatchingHandler();
    private IAS2IncomingMDNCallback m_aIncomingMDNCallback;
    private Consumer<? super X509Certificate> m_aVerificationCertificateConsumer;

    @Nonnull
    public final IMICMatchingHandler getMICMatchingHandler() {
        return this.m_aMICMatchingHandler;
    }

    @Nonnull
    public final AS2SenderModule setMICMatchingHandler(@Nonnull IMICMatchingHandler iMICMatchingHandler) {
        ValueEnforcer.notNull((Object)iMICMatchingHandler, (String)"MICMatchingHandler");
        this.m_aMICMatchingHandler = iMICMatchingHandler;
        return this;
    }

    @Nullable
    public final IAS2IncomingMDNCallback getIncomingMDNCallback() {
        return this.m_aIncomingMDNCallback;
    }

    public final void setIncomingMDNCallback(@Nullable IAS2IncomingMDNCallback iAS2IncomingMDNCallback) {
        this.m_aIncomingMDNCallback = iAS2IncomingMDNCallback;
    }

    @Nullable
    public final Consumer<? super X509Certificate> getVerificationCertificateConsumer() {
        return this.m_aVerificationCertificateConsumer;
    }

    @Nonnull
    public final AS2SenderModule setVerificationCertificateConsumer(@Nullable Consumer<? super X509Certificate> consumer) {
        this.m_aVerificationCertificateConsumer = consumer;
        return this;
    }

    @Override
    public boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        return "send".equals(string) && iMessage instanceof AS2Message;
    }

    protected void checkRequired(@Nonnull AS2Message aS2Message) throws AS2InvalidParameterException {
        Partnership partnership = aS2Message.partnership();
        try {
            AS2InvalidParameterException.checkValue(aS2Message, "ContentType", aS2Message.getContentType());
            AS2InvalidParameterException.checkValue(aS2Message, "Attribute: as2_url", partnership.getAS2URL());
            AS2InvalidParameterException.checkValue(aS2Message, "Receiver: as2_id", partnership.getReceiverAS2ID());
            AS2InvalidParameterException.checkValue(aS2Message, "Sender: as2_id", partnership.getSenderAS2ID());
            AS2InvalidParameterException.checkValue(aS2Message, "Subject", aS2Message.getSubject());
            AS2InvalidParameterException.checkValue(aS2Message, "Sender: email", partnership.getSenderEmail());
            AS2InvalidParameterException.checkValue(aS2Message, "Message Data", aS2Message.getData());
        }
        catch (AS2InvalidParameterException aS2InvalidParameterException) {
            aS2InvalidParameterException.setSourceMsg(aS2Message);
            throw aS2InvalidParameterException;
        }
    }

    @Nullable
    @OverrideOnDemand
    protected OutputStream openPendingInfoStreamForWriting(@Nonnull AS2Message aS2Message, @Nonnull @Nonempty String string) throws AS2Exception {
        String string2 = AS2IOHelper.getSafeFileAndFolderName(this.getSession().getMessageProcessor().getPendingMDNInfoFolder());
        if (StringHelper.hasNoText((String)string2)) {
            LOGGER.error("The pending MDN info folder is not properly configured. Cannot store async MDN data.");
            return null;
        }
        File file = new File(string2 + FilenameHelper.UNIX_SEPARATOR_STR + string);
        LOGGER.info("Saving original MIC and message id information into file '" + file.getAbsolutePath() + "'" + aS2Message.getLoggingText());
        return FileHelper.getOutputStream((File)file);
    }

    protected void storePendingInfo(@Nonnull AS2Message aS2Message, @Nonnull MIC mIC) throws AS2Exception {
        ValueEnforcer.notNull((Object)aS2Message, (String)"Msg");
        ValueEnforcer.notNull((Object)mIC, (String)"MIC");
        try {
            String string;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Original MIC is '" + mIC.getAsAS2String() + "'" + aS2Message.getLoggingText());
            }
            if (StringHelper.hasNoText((String)(string = AS2IOHelper.getSafeFileAndFolderName(this.getSession().getMessageProcessor().getPendingMDNFolder())))) {
                LOGGER.error("The pending MDN folder is not properly configured. Cannot store async MDN data.");
                return;
            }
            String string2 = AS2IOHelper.getFilenameFromMessageID(aS2Message.getMessageID());
            String string3 = string + FilenameHelper.UNIX_SEPARATOR_STR + string2;
            try (OutputStream outputStream = this.openPendingInfoStreamForWriting(aS2Message, string2);){
                if (outputStream == null) {
                    return;
                }
                try (OutputStreamWriter outputStreamWriter = StreamHelper.createWriter((OutputStream)outputStream, (Charset)StandardCharsets.ISO_8859_1);){
                    outputStreamWriter.write(mIC.getAsAS2String() + ENewLineMode.DEFAULT.getText() + string3);
                }
                aS2Message.attrs().putIn((Object)"pendingfilename", (Object)string3);
                aS2Message.attrs().putIn((Object)"status", (Object)"pending");
            }
        }
        catch (IOException iOException) {
            throw WrappedAS2Exception.wrap(iOException).setSourceMsg(aS2Message);
        }
    }

    @Nonnull
    protected MIC calculateAndStoreMIC(@Nonnull AS2Message aS2Message) throws Exception {
        Partnership partnership = aS2Message.partnership();
        boolean bl = partnership.getSigningAlgorithm() != null || partnership.getEncryptAlgorithm() != null || partnership.getCompressionType() != null;
        String string = partnership.getSigningAlgorithm();
        ECryptoAlgorithmSign eCryptoAlgorithmSign = ECryptoAlgorithmSign.getFromIDOrNull(string);
        if (eCryptoAlgorithmSign == null) {
            boolean bl2 = partnership.isRFC3851MICAlgs();
            eCryptoAlgorithmSign = bl2 ? ECryptoAlgorithmSign.DEFAULT_RFC_3851 : ECryptoAlgorithmSign.DEFAULT_RFC_5751;
            LOGGER.warn("The partnership signing algorithm name '" + string + "' is unknown. Fallbacking back to the default '" + eCryptoAlgorithmSign.getID() + "'");
        }
        MIC mIC = AS2Helper.getCryptoHelper().calculateMIC(aS2Message.getData(), eCryptoAlgorithmSign, bl);
        aS2Message.attrs().putIn((Object)"MIC", (Object)mIC.getAsAS2String());
        if (partnership.getAS2ReceiptDeliveryOption() != null) {
            this.storePendingInfo(aS2Message, mIC);
        }
        return mIC;
    }

    @Nonnull
    public static MimeBodyPart compressMimeBodyPart(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull ECompressionType eCompressionType, @Nonnull EContentTransferEncoding eContentTransferEncoding) throws SMIMEException {
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"Data");
        ValueEnforcer.notNull((Object)((Object)eCompressionType), (String)"CompressionType");
        ValueEnforcer.notNull((Object)eContentTransferEncoding, (String)"ContentTransferEncoding");
        SMIMECompressedGenerator sMIMECompressedGenerator = new SMIMECompressedGenerator();
        sMIMECompressedGenerator.setContentTransferEncoding(eContentTransferEncoding.getID());
        return sMIMECompressedGenerator.generate(mimeBodyPart, eCompressionType.createOutputCompressor());
    }

    private static void _logMimeBodyPart(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull String string) throws IOException, MessagingException {
    }

    @Nonnull
    public static MimeBodyPart secureMimeBodyPart(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull EContentTransferEncoding eContentTransferEncoding, @Nullable ECompressionType eCompressionType, boolean bl, @Nullable Consumer<MimeBodyPart> consumer, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign, @Nullable X509Certificate x509Certificate, @Nullable PrivateKey privateKey, boolean bl2, boolean bl3, boolean bl4, @Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt, @Nullable X509Certificate x509Certificate2, @Nonnull String string) throws Exception {
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"SrcPart");
        ValueEnforcer.notNull((Object)eContentTransferEncoding, (String)"ContentTransferEncoding");
        if (eCompressionType != null && bl) {
            ValueEnforcer.notNull(consumer, (String)"CompressBeforeSignCallback");
        }
        if (eCryptoAlgorithmSign != null) {
            ValueEnforcer.notNull((Object)x509Certificate, (String)"SenderCert");
            ValueEnforcer.notNull((Object)privateKey, (String)"SenderKey");
        }
        if (eCryptoAlgorithmCrypt != null) {
            ValueEnforcer.notNull((Object)x509Certificate2, (String)"ReceiverCert");
        }
        MimeBodyPart mimeBodyPart2 = mimeBodyPart;
        AS2SenderModule._logMimeBodyPart(mimeBodyPart2, "source");
        if (eCompressionType != null && bl) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Compressing outbound message before signing...");
            }
            mimeBodyPart2 = AS2SenderModule.compressMimeBodyPart(mimeBodyPart2, eCompressionType, eContentTransferEncoding);
            AS2SenderModule._logMimeBodyPart(mimeBodyPart2, "compressBeforeSign");
            consumer.accept(mimeBodyPart2);
            LOGGER.info("Successfully compressed outgoing AS2 message" + string);
        }
        if (eCryptoAlgorithmSign != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Signing outbound message...");
            }
            mimeBodyPart2 = AS2Helper.getCryptoHelper().sign(mimeBodyPart2, x509Certificate, privateKey, eCryptoAlgorithmSign, bl2, bl3, bl4, eContentTransferEncoding);
            AS2SenderModule._logMimeBodyPart(mimeBodyPart2, "signed");
            LOGGER.info("Successfully signed outgoing AS2 message" + string);
        }
        if (eCompressionType != null && !bl) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Compressing outbound message after signing...");
            }
            mimeBodyPart2 = AS2SenderModule.compressMimeBodyPart(mimeBodyPart2, eCompressionType, eContentTransferEncoding);
            AS2SenderModule._logMimeBodyPart(mimeBodyPart2, "compressAfterSign");
            LOGGER.info("Successfully compressed outgoing AS2 message" + string);
        }
        if (eCryptoAlgorithmCrypt != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Encrypting outbound message...");
            }
            mimeBodyPart2 = AS2Helper.getCryptoHelper().encrypt(mimeBodyPart2, x509Certificate2, eCryptoAlgorithmCrypt, eContentTransferEncoding);
            AS2SenderModule._logMimeBodyPart(mimeBodyPart2, "encrypted");
            LOGGER.info("Successfully encrypted outgoing AS2 message" + string);
        }
        return mimeBodyPart2;
    }

    @Nonnull
    protected MimeBodyPart secure(@Nonnull IMessage iMessage, @Nonnull EContentTransferEncoding eContentTransferEncoding) throws Exception {
        X509Certificate x509Certificate;
        Partnership partnership = iMessage.partnership();
        ICertificateFactory iCertificateFactory = this.getSession().getCertificateFactory();
        ECompressionType eCompressionType = null;
        boolean bl = true;
        Consumer<MimeBodyPart> consumer = null;
        Object object = partnership.getCompressionType();
        if (object != null) {
            eCompressionType = ECompressionType.getFromIDCaseInsensitiveOrNull((String)object);
            if (eCompressionType == null) {
                throw new AS2Exception("The compression type '" + (String)object + "' is not supported!");
            }
            bl = partnership.isCompressBeforeSign();
            if (bl) {
                consumer = iMessage::setData;
            }
        }
        object = null;
        X509Certificate x509Certificate2 = null;
        PrivateKey privateKey = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Object object2 = partnership.getSigningAlgorithm();
        if (object2 != null) {
            x509Certificate2 = iCertificateFactory.getCertificate(iMessage, ECertificatePartnershipType.SENDER);
            privateKey = iCertificateFactory.getPrivateKey(x509Certificate2);
            object = ECryptoAlgorithmSign.getFromIDOrNull((String)object2);
            if (object == null) {
                throw new AS2Exception("The signing algorithm '" + (String)object2 + "' is not supported!");
            }
            x509Certificate = iMessage.partnership().getIncludeCertificateInSignedContent();
            bl2 = x509Certificate.isDefined() ? x509Certificate.getAsBooleanValue() : this.getSession().isCryptoSignIncludeCertificateInBodyPart();
            bl3 = partnership.isRFC3851MICAlgs();
            bl4 = partnership.isRemoveCmsAlgorithmProtect();
        }
        object2 = null;
        x509Certificate = null;
        String string = partnership.getEncryptAlgorithm();
        if (string != null) {
            x509Certificate = iCertificateFactory.getCertificate(iMessage, ECertificatePartnershipType.RECEIVER);
            object2 = ECryptoAlgorithmCrypt.getFromIDOrNull(string);
            if (object2 == null) {
                throw new AS2Exception("The crypting algorithm '" + string + "' is not supported!");
            }
        }
        iMessage.headers().setHeader("Content-Transfer-Encoding", eContentTransferEncoding.getID());
        if ((eCompressionType != null || object2 != null) && iMessage.getData().getHeader("Content-Transfer-Encoding") == null) {
            iMessage.getData().setHeader("Content-Transfer-Encoding", eContentTransferEncoding.getID());
        }
        if (eCompressionType != null && object == null && object2 == null) {
            iMessage.headers().setHeader("Content-Type", CMimeType.APPLICATION_OCTET_STREAM.getAsStringWithoutParameters());
        }
        return AS2SenderModule.secureMimeBodyPart(iMessage.getData(), eContentTransferEncoding, eCompressionType, bl, consumer, (ECryptoAlgorithmSign)object, x509Certificate2, privateKey, bl2, bl3, bl4, (ECryptoAlgorithmCrypt)object2, x509Certificate, iMessage.getLoggingText());
    }

    protected void updateHttpHeaders(@Nonnull AS2HttpHeaderSetter aS2HttpHeaderSetter, @Nonnull IMessage iMessage) {
        String string;
        String string2;
        String string3;
        Partnership partnership = iMessage.partnership();
        HttpHeaderMap httpHeaderMap = iMessage.headers().getClone();
        httpHeaderMap.setHeader("Connection", "close, TE");
        httpHeaderMap.setHeader("User-Agent", CAS2Header.DEFAULT_USER_AGENT);
        httpHeaderMap.setHeader("Mime-Version", "1.0");
        httpHeaderMap.setHeader("AS2-Version", this.getSession().getAS2VersionID());
        httpHeaderMap.setHeader("Date", AS2DateHelper.getFormattedDateNow("EEE, dd MMM uuuu HH:mm:ss Z"));
        httpHeaderMap.setHeader("Message-ID", iMessage.getMessageID());
        httpHeaderMap.setHeader("Content-Type", iMessage.getContentType());
        httpHeaderMap.setHeader("Recipient-Address", partnership.getAS2URL());
        httpHeaderMap.setHeader("AS2-From", partnership.getSenderAS2ID());
        httpHeaderMap.setHeader("AS2-To", partnership.getReceiverAS2ID());
        httpHeaderMap.setHeader("Subject", iMessage.getSubject());
        httpHeaderMap.setHeader("From", partnership.getSenderEmail());
        httpHeaderMap.setHeader("Content-Transfer-Encoding", iMessage.getHeader("Content-Transfer-Encoding"));
        String string4 = partnership.getAS2MDNTo();
        if (string4 != null) {
            httpHeaderMap.setHeader("Disposition-Notification-To", string4);
        }
        if ((string3 = partnership.getAS2MDNOptions()) != null) {
            httpHeaderMap.setHeader("Disposition-Notification-Options", string3);
        }
        if ((string2 = partnership.getAS2ReceiptDeliveryOption()) != null) {
            httpHeaderMap.setHeader("Receipt-Delivery-Option", string2);
        }
        if ((string = iMessage.getContentDisposition()) != null) {
            httpHeaderMap.setHeader("Content-Disposition", string);
        }
        httpHeaderMap.forEachSingleHeader(aS2HttpHeaderSetter::setHttpHeader, false);
    }

    protected void receiveSyncMDN(@Nonnull AS2Message aS2Message, @Nonnull AS2HttpClient aS2HttpClient, @Nonnull MIC mIC, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws AS2Exception, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiving synchronous MDN for message" + aS2Message.getLoggingText());
        }
        try {
            boolean bl;
            AS2MessageMDN aS2MessageMDN = new AS2MessageMDN(aS2Message);
            aS2MessageMDN.headers().addAllHeaders(aS2HttpClient.getResponseHeaderFields());
            InputStream inputStream = aS2HttpClient.getInputStream();
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to((OutputStream)nonBlockingByteArrayOutputStream).closeTo(true).limit(StringParser.parseLong((String)aS2MessageMDN.getHeader("Content-Length"), (long)-1L)).build();
            if (iHTTPIncomingDumper != null) {
                iHTTPIncomingDumper.dumpIncomingRequest((List<String>)aS2MessageMDN.headers().getAllHeaderLines(true), nonBlockingByteArrayOutputStream.getBufferOrCopy(), aS2MessageMDN);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Retrieved MDN stream data:\n" + nonBlockingByteArrayOutputStream.getAsString(StandardCharsets.ISO_8859_1));
            }
            MimeBodyPart mimeBodyPart = new MimeBodyPart(AS2HttpHelper.getAsInternetHeaders(aS2MessageMDN.headers()), nonBlockingByteArrayOutputStream.getBufferOrCopy());
            aS2MessageMDN.setData(mimeBodyPart);
            aS2MessageMDN.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-From"));
            aS2MessageMDN.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-To"));
            aS2MessageMDN.partnership().setSenderX509Alias(aS2Message.partnership().getReceiverX509Alias());
            aS2MessageMDN.partnership().setReceiverX509Alias(aS2Message.partnership().getSenderX509Alias());
            this.getSession().getPartnershipFactory().updatePartnership(aS2MessageMDN, false);
            ICertificateFactory iCertificateFactory = this.getSession().getCertificateFactory();
            X509Certificate x509Certificate = iCertificateFactory.getCertificate(aS2MessageMDN, ECertificatePartnershipType.SENDER);
            ETriState eTriState = aS2Message.partnership().getVerifyUseCertificateInBodyPart();
            boolean bl2 = eTriState.isDefined() ? eTriState.getAsBooleanValue() : this.getSession().isCryptoVerifyUseCertificateInBodyPart();
            AS2Helper.parseMDN(aS2Message, x509Certificate, bl2, this.m_aVerificationCertificateConsumer, aS2ResourceHelper);
            try {
                this.getSession().getMessageProcessor().handle("storemdn", aS2Message, null);
            }
            catch (AS2NoModuleException | AS2ComponentNotFoundException aS2Exception) {
                // empty catch block
            }
            String string = aS2MessageMDN.attrs().getAsString((Object)"DISPOSITION");
            LOGGER.info("Received synchronous AS2 MDN [" + string + "]" + aS2Message.getLoggingText());
            String string2 = aS2MessageMDN.attrs().getAsString((Object)"MIC");
            MIC mIC2 = MIC.parse(string2);
            boolean bl3 = bl = mIC != null && mIC2 != null && mIC2.equals(mIC);
            if (bl) {
                this.m_aMICMatchingHandler.onMICMatch(aS2Message, string2);
            } else {
                this.m_aMICMatchingHandler.onMICMismatch(aS2Message, mIC == null ? null : mIC.getAsAS2String(), string2);
            }
            if (this.m_aIncomingMDNCallback != null) {
                this.m_aIncomingMDNCallback.onIncomingMDN(true, aS2MessageMDN, aS2MessageMDN.getHeader("AS2-From"), aS2MessageMDN.getHeader("AS2-To"), string, aS2MessageMDN.attrs().getAsString((Object)"MIC"), aS2MessageMDN.attrs().getAsString((Object)"ORIGINAL_MESSAGE_ID"), aS2MessageMDN.attrs().getAsBoolean((Object)"as2msg.received.signed", false), bl);
            }
            DispositionType.createFromString(string).validate(aS2Message, aS2MessageMDN.getText());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw WrappedAS2Exception.wrap(exception).setSourceMsg(aS2Message);
        }
    }

    @OverrideOnDemand
    protected void onReceivedMDNError(@Nonnull AS2Message aS2Message, @Nonnull AS2Exception aS2Exception) throws AS2Exception {
        new AS2Exception("Message was sent but an error occured while receiving the MDN", aS2Exception).terminate(aS2Message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendViaHTTP(@Nonnull AS2Message aS2Message, @Nonnull MimeBodyPart mimeBodyPart, @Nullable MIC mIC, @Nullable EContentTransferEncoding eContentTransferEncoding, @Nullable IHTTPOutgoingDumper iHTTPOutgoingDumper, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws AS2Exception, IOException, MessagingException {
        Partnership partnership = aS2Message.partnership();
        String string = partnership.getAS2URL();
        EHttpMethod eHttpMethod = EHttpMethod.POST;
        AS2HttpClient aS2HttpClient = this.getHttpClient(string, eHttpMethod, this.getSession().getHttpProxy());
        try {
            if (iHTTPOutgoingDumper != null) {
                iHTTPOutgoingDumper.start(string, aS2Message);
            }
            LOGGER.info("Connecting to " + string + aS2Message.getLoggingText());
            boolean bl = this.isQuoteHeaderValues();
            this.updateHttpHeaders(new AS2HttpHeaderSetter(aS2HttpClient, iHTTPOutgoingDumper, bl), aS2Message);
            if (iHTTPOutgoingDumper != null) {
                iHTTPOutgoingDumper.finishedHeaders();
            }
            aS2Message.attrs().putIn((Object)"destination_ip", (Object)aS2HttpClient.getURL().getHost());
            aS2Message.attrs().putIn("destination_port", aS2HttpClient.getURL().getPort());
            InputStream inputStream = mimeBodyPart.getInputStream();
            StopWatch stopWatch = StopWatch.createdStarted();
            long l = aS2HttpClient.send(inputStream, eContentTransferEncoding, iHTTPOutgoingDumper, aS2ResourceHelper);
            stopWatch.stop();
            LOGGER.info("AS2 Message transferred " + AS2IOHelper.getTransferRate(l, stopWatch) + aS2Message.getLoggingText());
            if (iHTTPOutgoingDumper != null) {
                iHTTPOutgoingDumper.finishedPayload();
            }
            int n = aS2HttpClient.getResponseCode();
            if (this.getOutgoingHttpCallback() != null) {
                this.getOutgoingHttpCallback().onOutgoingHttpMessage(true, aS2Message.getAS2From(), aS2Message.getAS2To(), aS2Message.getMessageID(), mIC == null ? null : mIC.getClone(), eContentTransferEncoding, string, n);
            }
            if (AS2HttpClient.isErrorResponseCode(n)) {
                LOGGER.error("Error URL '" + string + "' - HTTP " + n + " " + aS2HttpClient.getResponseMessage() + " " + aS2Message.getLoggingText());
                throw new AS2HttpResponseException(string, n, aS2HttpClient.getResponseMessage());
            }
            try {
                if (aS2Message.isRequestingMDN() && partnership.getAS2ReceiptDeliveryOption() == null) {
                    assert (mIC != null);
                    this.receiveSyncMDN(aS2Message, aS2HttpClient, mIC, iHTTPIncomingDumper, aS2ResourceHelper);
                    LOGGER.info("message sent" + aS2Message.getLoggingText());
                }
            }
            catch (AS2DispositionException aS2DispositionException) {
                throw aS2DispositionException;
            }
            catch (AS2Exception aS2Exception) {
                this.onReceivedMDNError(aS2Message, aS2Exception);
            }
        }
        finally {
            aS2HttpClient.disconnect();
        }
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        AS2Message aS2Message = (AS2Message)iMessage;
        LOGGER.info("Submitting message" + aS2Message.getLoggingText());
        this.checkRequired(aS2Message);
        int n = this.getRetryCount(aS2Message.partnership(), map);
        try (AS2ResourceHelper aS2ResourceHelper = new AS2ResourceHelper();){
            String string2 = aS2Message.partnership().getContentTransferEncodingSend(EContentTransferEncoding.AS2_DEFAULT.getID());
            EContentTransferEncoding eContentTransferEncoding = EContentTransferEncoding.getFromIDCaseInsensitiveOrDefault((String)string2, (EContentTransferEncoding)EContentTransferEncoding.AS2_DEFAULT);
            MimeBodyPart mimeBodyPart = this.secure(aS2Message, eContentTransferEncoding);
            MIC mIC = aS2Message.isRequestingMDN() ? this.calculateAndStoreMIC(aS2Message) : null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting message content type to '" + mimeBodyPart.getContentType() + "'");
            }
            aS2Message.setContentType(mimeBodyPart.getContentType());
            try (IHTTPOutgoingDumper iHTTPOutgoingDumper = this.getHttpOutgoingDumper(aS2Message);){
                IHTTPIncomingDumper iHTTPIncomingDumper = this.getEffectiveHttpIncomingDumper();
                this._sendViaHTTP(aS2Message, mimeBodyPart, mIC, null, iHTTPOutgoingDumper, iHTTPIncomingDumper, aS2ResourceHelper);
            }
        }
        catch (AS2HttpResponseException aS2HttpResponseException) {
            LOGGER.error("Http Response Error " + aS2HttpResponseException.getMessage());
            aS2HttpResponseException.terminate(aS2Message);
            if (!this.doResend("send", aS2Message, aS2HttpResponseException, n)) {
                throw aS2HttpResponseException;
            }
        }
        catch (IOException iOException) {
            AS2Exception aS2Exception = WrappedAS2Exception.wrap(iOException).setSourceMsg(aS2Message).terminate();
            if (!this.doResend("send", aS2Message, aS2Exception, n)) {
                throw aS2Exception;
            }
        }
        catch (Exception exception) {
            throw WrappedAS2Exception.wrap(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

