/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.dump;

import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.CHttp;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

public class HTTPIncomingDumperStreamBased
implements IHTTPIncomingDumper {
    private final OutputStream m_aOS;

    public HTTPIncomingDumperStreamBased(@Nonnull @WillCloseWhenClosed OutputStream outputStream) {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        this.m_aOS = outputStream;
    }

    @Nonnull
    protected final OutputStream getWrappedOS() {
        return this.m_aOS;
    }

    @Override
    public void dumpIncomingRequest(@Nonnull List<String> list, @Nonnull byte[] byArray, @Nullable IBaseMessage iBaseMessage) {
        try {
            for (String string : list) {
                this.m_aOS.write(string.getBytes(CHttp.HTTP_CHARSET));
            }
            if (!list.isEmpty()) {
                this.m_aOS.write("\r\n".getBytes(CHttp.HTTP_CHARSET));
            }
            this.m_aOS.write(byArray);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            StreamHelper.close((AutoCloseable)this.m_aOS);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("OutputStream", (Object)this.m_aOS).getToString();
    }
}

