/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.util.dump.IHTTPOutgoingDumper;
import com.helger.as2lib.util.http.AS2HttpClient;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.HttpHeaderMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AS2HttpHeaderSetter {
    private final AS2HttpClient m_aConn;
    private final IHTTPOutgoingDumper m_aOutgoingDumper;
    private final boolean m_bQuoteHeaderValues;

    public AS2HttpHeaderSetter(@Nonnull AS2HttpClient aS2HttpClient, @Nullable IHTTPOutgoingDumper iHTTPOutgoingDumper, boolean bl) {
        this.m_aConn = (AS2HttpClient)ValueEnforcer.notNull((Object)aS2HttpClient, (String)"Connection");
        this.m_aOutgoingDumper = iHTTPOutgoingDumper;
        this.m_bQuoteHeaderValues = bl;
    }

    public void setHttpHeader(@Nonnull String string, @Nonnull String string2) {
        String string3 = HttpHeaderMap.getUnifiedValue((String)string2, (boolean)this.m_bQuoteHeaderValues);
        this.m_aConn.setHttpHeader(string, string3);
        if (this.m_aOutgoingDumper != null) {
            this.m_aOutgoingDumper.dumpHeader(string, string3);
        }
    }
}

