/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.util.AS2IOHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.string.StringHelper;
import jakarta.mail.util.SharedFileInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempSharedFileInputStream
extends SharedFileInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempSharedFileInputStream.class);
    private final File m_aTempFile;

    private TempSharedFileInputStream(@Nonnull File file) throws IOException {
        super(file);
        this.m_aTempFile = file;
    }

    public void close() throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("close() called, doing nothing.");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.closeAndDelete();
        }
        catch (Exception exception) {
            LOGGER.error("Exception in finalize()", (Throwable)exception);
        }
        super.finalize();
    }

    @Deprecated(forRemoval=true, since="4.10.2")
    public void closeAll() throws IOException {
        this.closeAndDelete();
    }

    public void closeAndDelete() throws IOException {
        try {
            super.close();
        }
        finally {
            AS2IOHelper.getFileOperationManager().deleteFileIfExisting(this.m_aTempFile);
        }
    }

    @Nonnull
    protected static File storeContentToTempFile(@Nonnull @WillClose InputStream inputStream, @Nonnull String string) throws IOException {
        String string2 = FilenameHelper.getAsSecureValidASCIIFilename((String)(StringHelper.hasText((String)string) ? string : "tmp"));
        File file = Files.createTempFile("AS2TempSharedFileIS", string2, new FileAttribute[0]).toFile();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            MutableLong mutableLong = new MutableLong(0L);
            StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to((OutputStream)fileOutputStream).closeTo(false).copyByteCount(mutableLong).build();
            if (mutableLong.longValue() > 1024L) {
                LOGGER.info(mutableLong.longValue() + " bytes copied to " + file.getAbsolutePath());
            }
        }
        return file;
    }

    @Nonnull
    public static TempSharedFileInputStream getTempSharedFileInputStream(@Nonnull @WillClose InputStream inputStream, @Nonnull String string) throws IOException {
        File file = TempSharedFileInputStream.storeContentToTempFile(inputStream, string);
        return new TempSharedFileInputStream(file);
    }
}

