/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.ICharArrayDecoder;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Writer;

@FunctionalInterface
public interface ICharArrayStreamDecoder
extends ICharArrayDecoder {
    default public void decode(@Nullable char[] cArray, @Nonnull @WillNotClose Writer writer) {
        if (cArray == null) {
            this.decode(null, 0, 0, writer);
        } else {
            this.decode(cArray, 0, cArray.length, writer);
        }
    }

    public void decode(@Nullable char[] var1, @Nonnegative int var2, @Nonnegative int var3, @Nonnull @WillNotClose Writer var4);

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public char[] getDecoded(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumDecodedLength(n2));){
            this.decode(cArray, n, n2, nonBlockingStringWriter);
            char[] cArray2 = nonBlockingStringWriter.getAsCharArray();
            return cArray2;
        }
    }

    @Nullable
    default public String getDecodedAsString(@Nullable char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return this.getDecodedAsString(cArray, 0, cArray.length);
    }

    @Nullable
    default public String getDecodedAsString(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumDecodedLength(n2));){
            this.decode(cArray, n, n2, nonBlockingStringWriter);
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
    }

    @Nullable
    default public String getDecodedAsString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        return this.getDecodedAsString(cArray, 0, cArray.length);
    }
}

