/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WrappedOutputStream
extends FilterOutputStream {
    public WrappedOutputStream(@Nonnull OutputStream outputStream) {
        super(ValueEnforcer.notNull(outputStream, "WrappedOutputStream"));
    }

    @Nonnull
    public final OutputStream getWrappedOutputStream() {
        return this.out;
    }

    @Override
    public void write(@Nonnull byte[] byArray, int n, int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.out.write(byArray, n, n2);
    }

    public String toString() {
        return new ToStringGenerator(this).append("wrappedOS", this.out).getToString();
    }
}

