/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.classloader;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ClassLoaderHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderHelper.class);
    private static final ClassLoaderHelper INSTANCE = new ClassLoaderHelper();

    protected ClassLoaderHelper() {
    }

    @Nonnull
    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    @Nullable
    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static void setContextClassLoader(@Nonnull ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    @Nullable
    public static ClassLoader getClassClassLoader(@Nonnull Class<?> clazz) {
        return clazz.getClassLoader();
    }

    @Nullable
    public static ClassLoader getParentClassLoader(@Nonnull ClassLoader classLoader) {
        return classLoader.getParent();
    }

    @Nonnull
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = ClassLoaderHelper.getContextClassLoader();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = ClassLoaderHelper.getClassClassLoader(ClassLoaderHelper.class);
        }
        return classLoader;
    }

    @Nonnull
    protected static String internalGetPathWithoutLeadingSlash(@Nonnull @Nonempty String string) {
        return string.charAt(0) == '/' ? string.substring(1) : string;
    }

    @Nullable
    public static URL getResource(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper.internalGetPathWithoutLeadingSlash(string);
        try {
            return classLoader.getResource(string2);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn("Unexpected runtime exception gathering resource '" + string2 + "'", (Throwable)runtimeException);
            return null;
        }
    }

    @Nonnull
    public static Enumeration<URL> getResources(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) throws IOException {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper.internalGetPathWithoutLeadingSlash(string);
        return classLoader.getResources(string2);
    }

    @Nullable
    public static InputStream getResourceAsStream(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper.internalGetPathWithoutLeadingSlash(string);
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        return StreamHelper.checkForInvalidFilterInputStream(inputStream);
    }
}

