/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonnegative;
import com.helger.base.io.stream.WrappedWriter;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Writer;

public class CountingWriter
extends WrappedWriter {
    private long m_nCharsWritten = 0L;

    public CountingWriter(@Nonnull Writer writer) {
        super(writer);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        ++this.m_nCharsWritten;
    }

    @Override
    public void write(@Nonnull char[] cArray, int n, int n2) throws IOException {
        super.write(cArray, n, n2);
        this.m_nCharsWritten += (long)n2;
    }

    @Nonnegative
    public final long getCharsWritten() {
        return this.m_nCharsWritten;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("CharsWritten", this.m_nCharsWritten).getToString();
    }
}

