/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.IDecoder;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IByteArrayDecoder
extends IDecoder<byte[], byte[]> {
    @Nonnegative
    default public int getMaximumDecodedLength(@Nonnegative int n) {
        return n;
    }

    @Override
    @ReturnsMutableCopy
    default public @Nullable byte[] getDecoded(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.getDecoded(byArray, 0, byArray.length);
    }

    @ReturnsMutableCopy
    public @Nullable byte[] getDecoded(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    @ReturnsMutableCopy
    default public @Nullable byte[] getDecoded(@Nullable String string, @NonNull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getDecoded(byArray);
    }
}

