/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.concurrent;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;

@Immutable
@ThreadSafe
public final class ThreadHelper {
    private ThreadHelper() {
    }

    public static @NonNull ESuccess sleepMinutes(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Minutes");
        return ThreadHelper.sleep(l * 60000L);
    }

    public static @NonNull ESuccess sleepSeconds(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Seconds");
        return ThreadHelper.sleep(l * 1000L);
    }

    public static @NonNull ESuccess sleep(@NonNull Duration duration) {
        ValueEnforcer.notNull(duration, "Duration");
        return ThreadHelper.sleep(duration.toMillis());
    }

    public static @NonNull ESuccess sleep(@Nonnegative long l, @NonNull TimeUnit timeUnit) {
        ValueEnforcer.isGE0(l, "Duration");
        ValueEnforcer.notNull(timeUnit, "TimeUnit");
        return ThreadHelper.sleep(timeUnit.toMillis(l));
    }

    public static @NonNull ESuccess sleep(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "MilliSeconds");
        try {
            Thread.sleep(l);
            return ESuccess.SUCCESS;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return ESuccess.FAILURE;
        }
    }
}

