/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.functional;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.functional.ICharPredicate;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class Predicates {
    private Predicates() {
    }

    public static <DATATYPE> @NonNull Predicate<DATATYPE> all() {
        return object -> true;
    }

    public static <DATATYPE> @NonNull Predicate<DATATYPE> none() {
        return object -> false;
    }

    public static <DATATYPE> @NonNull Predicate<DATATYPE> notNull() {
        return Objects::nonNull;
    }

    public static <DATATYPE> @NonNull Predicate<DATATYPE> isNull() {
        return Objects::isNull;
    }

    public static @NonNull ICharPredicate charIsEQ0() {
        return c -> c == '\u0000';
    }

    public static @NonNull ICharPredicate charIsNE0() {
        return c -> c != '\u0000';
    }

    public static @NonNull ICharPredicate charIsGT0() {
        return c -> c > '\u0000';
    }

    public static @NonNull DoublePredicate doubleIsLT0() {
        return d -> d < 0.0;
    }

    public static @NonNull DoublePredicate doubleIsLE0() {
        return d -> d <= 0.0;
    }

    public static @NonNull DoublePredicate doubleIsEQ0() {
        return d -> d == 0.0;
    }

    public static @NonNull DoublePredicate doubleIsNE0() {
        return d -> d != 0.0;
    }

    public static @NonNull DoublePredicate doubleIsGE0() {
        return d -> d >= 0.0;
    }

    public static @NonNull DoublePredicate doubleIsGT0() {
        return d -> d > 0.0;
    }

    public static @NonNull IntPredicate intIsLT0() {
        return n -> n < 0;
    }

    public static @NonNull IntPredicate intIsLE0() {
        return n -> n <= 0;
    }

    public static @NonNull IntPredicate intIsEQ0() {
        return n -> n == 0;
    }

    public static @NonNull IntPredicate intIsNE0() {
        return n -> n != 0;
    }

    public static @NonNull IntPredicate intIsGE0() {
        return n -> n >= 0;
    }

    public static @NonNull IntPredicate intIsGT0() {
        return n -> n > 0;
    }

    public static @NonNull LongPredicate longIsLT0() {
        return l -> l < 0L;
    }

    public static @NonNull LongPredicate longIsLE0() {
        return l -> l <= 0L;
    }

    public static @NonNull LongPredicate longIsEQ0() {
        return l -> l == 0L;
    }

    public static @NonNull LongPredicate longIsNE0() {
        return l -> l != 0L;
    }

    public static @NonNull LongPredicate longIsGE0() {
        return l -> l >= 0L;
    }

    public static @NonNull LongPredicate longIsGT0() {
        return l -> l > 0L;
    }

    public static <T> @Nullable Predicate<T> and(@Nullable Predicate<? super T> predicate, @Nullable Predicate<? super T> predicate2) {
        if (predicate != null) {
            if (predicate2 != null) {
                return object -> predicate.test(object) && predicate2.test(object);
            }
            return predicate::test;
        }
        if (predicate2 != null) {
            return predicate2::test;
        }
        return null;
    }

    public static <T> @Nullable Predicate<T> or(@Nullable Predicate<? super T> predicate, @Nullable Predicate<? super T> predicate2) {
        if (predicate != null) {
            if (predicate2 != null) {
                return object -> predicate.test(object) || predicate2.test(object);
            }
            return predicate::test;
        }
        if (predicate2 != null) {
            return predicate2::test;
        }
        return null;
    }
}

