/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.iface;

import com.helger.base.io.stream.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IHasInputStream {
    public @Nullable InputStream getInputStream();

    default public @Nullable InputStream getBufferedInputStream() {
        return StreamHelper.getBuffered(this.getInputStream());
    }

    default public <T> @Nullable T withInputStreamDo(@NonNull Function<InputStream, T> function) throws IOException {
        try (InputStream inputStream = this.getInputStream();){
            T t = function.apply(inputStream);
            return t;
        }
    }

    default public <T> @Nullable T withBufferedInputStreamDo(@NonNull Function<InputStream, T> function) throws IOException {
        try (InputStream inputStream = this.getBufferedInputStream();){
            T t = function.apply(inputStream);
            return t;
        }
    }

    public boolean isReadMultiple();
}

