/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.iface.IHasInputStreamAndReader;
import com.helger.base.io.iface.IHasReader;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.stream.StringInputStream;
import com.helger.base.tostring.ToStringGenerator;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;

public class StringInputStreamProvider
implements IHasInputStreamAndReader,
IHasReader {
    private String m_sData;
    private Charset m_aCharset;

    public StringInputStreamProvider(@NonNull char[] cArray, @NonNull Charset charset) {
        this(new String(cArray), charset);
    }

    public StringInputStreamProvider(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @NonNull Charset charset) {
        this(new String(cArray, n, n2), charset);
    }

    public StringInputStreamProvider(@NonNull CharSequence charSequence, @NonNull Charset charset) {
        this(charSequence.toString(), charset);
    }

    public StringInputStreamProvider(@NonNull String string, @NonNull Charset charset) {
        this.m_sData = ValueEnforcer.notNull(string, "Data");
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    public final @NonNull String getData() {
        return this.m_sData;
    }

    public final @NonNull Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    public final @NonNull StringInputStream getInputStream() {
        return new StringInputStream(this.m_sData, this.m_aCharset);
    }

    @Override
    public final @NonNull NonBlockingStringReader getReader(@NonNull Charset charset) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    public final @NonNull NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringInputStreamProvider stringInputStreamProvider = (StringInputStreamProvider)object;
        return this.m_sData.equals(stringInputStreamProvider.m_sData) && this.m_aCharset.equals(stringInputStreamProvider.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sData).append(this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).append("charset", this.m_aCharset).getToString();
    }
}

