/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.base.numeric.INumber;
import com.helger.base.numeric.mutable.IMutableObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jspecify.annotations.NonNull;

public interface IMutableNumeric<IMPLTYPE extends IMutableNumeric<IMPLTYPE>>
extends IMutableObject<IMPLTYPE>,
INumber {
    public boolean is0();

    default public boolean isNot0() {
        return !this.is0();
    }

    public boolean isLT0();

    public boolean isLE0();

    public boolean isGT0();

    public boolean isGE0();

    default public @NonNull Byte getAsByte() {
        return this.byteValue();
    }

    default public @NonNull Character getAsCharacter() {
        return Character.valueOf((char)this.intValue());
    }

    default public @NonNull Double getAsDouble() {
        return this.doubleValue();
    }

    default public @NonNull Float getAsFloat() {
        return Float.valueOf(this.floatValue());
    }

    default public @NonNull Integer getAsInteger() {
        return this.intValue();
    }

    default public @NonNull Long getAsLong() {
        return this.longValue();
    }

    default public @NonNull Short getAsShort() {
        return this.shortValue();
    }

    default public @NonNull BigInteger getAsBigInteger() {
        return BigInteger.valueOf(this.longValue());
    }

    default public @NonNull BigDecimal getAsBigDecimal() {
        return BigDecimal.valueOf(this.doubleValue());
    }
}

