/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.AbstractMutableNumeric;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class MutableDouble
extends AbstractMutableNumeric<MutableDouble> {
    private double m_dValue;

    public MutableDouble(@NonNull Number number) {
        this(number.doubleValue());
    }

    public MutableDouble(double d) {
        this.m_dValue = d;
    }

    @Override
    public double doubleValue() {
        return this.m_dValue;
    }

    @Override
    public float floatValue() {
        return (float)this.m_dValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_dValue;
    }

    @Override
    public long longValue() {
        return (long)this.m_dValue;
    }

    public double inc() {
        return this.inc(1.0);
    }

    public double inc(double d) {
        this.m_dValue += d;
        this.onAfterChange();
        return this.m_dValue;
    }

    public double inc(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.doubleValue());
    }

    public double dec() {
        return this.inc(-1.0);
    }

    public double dec(double d) {
        return this.inc(-d);
    }

    public double dec(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.doubleValue());
    }

    public double divide(double d) {
        this.m_dValue /= d;
        this.onAfterChange();
        return this.m_dValue;
    }

    public double divide(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Divisor");
        return this.divide(number.doubleValue());
    }

    public double multiply(double d) {
        this.m_dValue *= d;
        this.onAfterChange();
        return this.m_dValue;
    }

    public double multiply(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Multiplicand");
        return this.multiply(number.doubleValue());
    }

    public @NonNull EChange set(double d) {
        if (EqualsHelper.equals(d, this.m_dValue)) {
            return EChange.UNCHANGED;
        }
        this.m_dValue = d;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    public @NonNull EChange set(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.doubleValue());
    }

    @Override
    public boolean is0() {
        return EqualsHelper.equals(this.m_dValue, 0.0);
    }

    @Override
    public boolean isLT0() {
        return CompareHelper.compare(this.m_dValue, 0.0) < 0;
    }

    @Override
    public boolean isLE0() {
        return CompareHelper.compare(this.m_dValue, 0.0) <= 0;
    }

    @Override
    public boolean isGT0() {
        return CompareHelper.compare(this.m_dValue, 0.0) > 0;
    }

    @Override
    public boolean isGE0() {
        return CompareHelper.compare(this.m_dValue, 0.0) >= 0;
    }

    public double getAndInc() {
        double d = this.doubleValue();
        this.inc();
        return d;
    }

    public double incAndGet() {
        this.inc();
        return this.doubleValue();
    }

    @Override
    public int compareTo(@NonNull MutableDouble mutableDouble) {
        return CompareHelper.compare(this.m_dValue, mutableDouble.m_dValue);
    }

    @Override
    public @NonNull MutableDouble getClone() {
        return new MutableDouble(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableDouble mutableDouble = (MutableDouble)object;
        return EqualsHelper.equals(this.m_dValue, mutableDouble.m_dValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_dValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_dValue).getToString();
    }
}

