/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.AbstractMutableInteger;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class MutableInt
extends AbstractMutableInteger<MutableInt> {
    private int m_nValue;

    public MutableInt(@NonNull Number number) {
        this(number.intValue());
    }

    public MutableInt(int n) {
        this.m_nValue = n;
    }

    @Override
    public int intValue() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_nValue += n;
        this.onAfterChange();
        return this.m_nValue;
    }

    public int inc(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.intValue());
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    public int dec(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.intValue());
    }

    public int divide(int n) {
        this.m_nValue /= n;
        this.onAfterChange();
        return this.m_nValue;
    }

    public int divide(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Divisor");
        return this.divide(number.intValue());
    }

    public int multiply(int n) {
        this.m_nValue *= n;
        this.onAfterChange();
        return this.m_nValue;
    }

    public int multiply(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Multiplicand");
        return this.multiply(number.intValue());
    }

    public @NonNull EChange set(int n) {
        if (this.m_nValue == n) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = n;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    public @NonNull EChange set(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.intValue());
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0;
    }

    @Override
    public boolean isLT0() {
        return this.m_nValue < 0;
    }

    @Override
    public boolean isLE0() {
        return this.m_nValue <= 0;
    }

    @Override
    public boolean isGT0() {
        return this.m_nValue > 0;
    }

    @Override
    public boolean isGE0() {
        return this.m_nValue >= 0;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2 == 0;
    }

    public int getAndInc() {
        int n = this.intValue();
        this.inc();
        return n;
    }

    public int incAndGet() {
        this.inc();
        return this.intValue();
    }

    @Override
    public int compareTo(@NonNull MutableInt mutableInt) {
        return CompareHelper.compare(this.m_nValue, mutableInt.m_nValue);
    }

    @Override
    public @NonNull MutableInt getClone() {
        return new MutableInt(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableInt mutableInt = (MutableInt)object;
        return this.m_nValue == mutableInt.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).getToString();
    }
}

