/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.AbstractMutableInteger;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class MutableLong
extends AbstractMutableInteger<MutableLong> {
    private long m_nValue;

    public MutableLong(@NonNull Number number) {
        this(number.longValue());
    }

    public MutableLong(long l) {
        this.m_nValue = l;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_nValue;
    }

    public long inc() {
        return this.inc(1L);
    }

    public long inc(long l) {
        this.m_nValue += l;
        this.onAfterChange();
        return this.m_nValue;
    }

    public long inc(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.longValue());
    }

    public long dec() {
        return this.inc(-1L);
    }

    public long dec(long l) {
        return this.inc(-l);
    }

    public long dec(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.longValue());
    }

    public long divide(long l) {
        this.m_nValue /= l;
        this.onAfterChange();
        return this.m_nValue;
    }

    public long divide(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Divisor");
        return this.divide(number.longValue());
    }

    public long multiply(long l) {
        this.m_nValue *= l;
        this.onAfterChange();
        return this.m_nValue;
    }

    public long multiply(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Multiplicand");
        return this.multiply(number.longValue());
    }

    public @NonNull EChange set(long l) {
        if (l == this.m_nValue) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = l;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    public @NonNull EChange set(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.longValue());
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0L;
    }

    @Override
    public boolean isLT0() {
        return this.m_nValue < 0L;
    }

    @Override
    public boolean isLE0() {
        return this.m_nValue <= 0L;
    }

    @Override
    public boolean isGT0() {
        return this.m_nValue > 0L;
    }

    @Override
    public boolean isGE0() {
        return this.m_nValue >= 0L;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2L == 0L;
    }

    public long getAndInc() {
        long l = this.longValue();
        this.inc();
        return l;
    }

    public long incAndGet() {
        this.inc();
        return this.longValue();
    }

    @Override
    public int compareTo(@NonNull MutableLong mutableLong) {
        return CompareHelper.compare(this.m_nValue, mutableLong.m_nValue);
    }

    @Override
    public @NonNull MutableLong getClone() {
        return new MutableLong(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableLong mutableLong = (MutableLong)object;
        return this.m_nValue == mutableLong.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).getToString();
    }
}

