/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.serialize;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.reflection.GenericReflection;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jspecify.annotations.NonNull;

@Immutable
public final class SerializationHelper {
    private SerializationHelper() {
    }

    public static @NonNull byte[] getSerializedByteArray(@NonNull Serializable serializable) {
        ValueEnforcer.notNull(serializable, "Data");
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            try (Object object = new ObjectOutputStream(nonBlockingByteArrayOutputStream);){
                ((ObjectOutputStream)object).writeObject(serializable);
            }
            object = nonBlockingByteArrayOutputStream.toByteArray();
            nonBlockingByteArrayOutputStream.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                try {
                    nonBlockingByteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NotSerializableException notSerializableException) {
                throw new IllegalArgumentException("Not serializable: " + notSerializableException.getMessage(), notSerializableException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to write serializable object " + String.valueOf(serializable) + " of type " + serializable.getClass().getName(), iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> @NonNull T getDeserializedObject(@NonNull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Data");
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new NonBlockingByteArrayInputStream(byArray));){
            Object DSTTYPE = GenericReflection.uncheckedCast(objectInputStream.readObject());
            return (T)DSTTYPE;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to read serializable object", exception);
        }
    }
}

