/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.helper;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.stack.NonBlockingStack;
import jakarta.annotation.Nonnull;

public final class PrimitiveCollectionHelper {
    private PrimitiveCollectionHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Boolean> createPrimitiveList(boolean ... blArray) {
        CommonsArrayList<Boolean> commonsArrayList = new CommonsArrayList<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsArrayList.add(bl);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Byte> createPrimitiveList(byte ... byArray) {
        CommonsArrayList<Byte> commonsArrayList = new CommonsArrayList<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsArrayList.add(by);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Character> createPrimitiveList(char ... cArray) {
        CommonsArrayList<Character> commonsArrayList = new CommonsArrayList<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                commonsArrayList.add(Character.valueOf(c));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Double> createPrimitiveList(double ... dArray) {
        CommonsArrayList<Double> commonsArrayList = new CommonsArrayList<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                commonsArrayList.add(d);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Float> createPrimitiveList(float ... fArray) {
        CommonsArrayList<Float> commonsArrayList = new CommonsArrayList<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                commonsArrayList.add(Float.valueOf(f));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Integer> createPrimitiveList(int ... nArray) {
        CommonsArrayList<Integer> commonsArrayList = new CommonsArrayList<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                commonsArrayList.add(n);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Long> createPrimitiveList(long ... lArray) {
        CommonsArrayList<Long> commonsArrayList = new CommonsArrayList<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                commonsArrayList.add(l);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Short> createPrimitiveList(short ... sArray) {
        CommonsArrayList<Short> commonsArrayList = new CommonsArrayList<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                commonsArrayList.add(s);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Boolean> createPrimitiveSet(boolean ... blArray) {
        CommonsHashSet<Boolean> commonsHashSet = new CommonsHashSet<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsHashSet.add(bl);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Byte> createPrimitiveSet(byte ... byArray) {
        CommonsHashSet<Byte> commonsHashSet = new CommonsHashSet<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsHashSet.add(by);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Character> createPrimitiveSet(char ... cArray) {
        CommonsHashSet<Character> commonsHashSet = new CommonsHashSet<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                commonsHashSet.add(Character.valueOf(c));
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Double> createPrimitiveSet(double ... dArray) {
        CommonsHashSet<Double> commonsHashSet = new CommonsHashSet<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                commonsHashSet.add(d);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Float> createPrimitiveSet(float ... fArray) {
        CommonsHashSet<Float> commonsHashSet = new CommonsHashSet<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                commonsHashSet.add(Float.valueOf(f));
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Integer> createPrimitiveSet(int ... nArray) {
        CommonsHashSet<Integer> commonsHashSet = new CommonsHashSet<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                commonsHashSet.add(n);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Long> createPrimitiveSet(long ... lArray) {
        CommonsHashSet<Long> commonsHashSet = new CommonsHashSet<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                commonsHashSet.add(l);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Short> createPrimitiveSet(short ... sArray) {
        CommonsHashSet<Short> commonsHashSet = new CommonsHashSet<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                commonsHashSet.add(s);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Boolean> createPrimitiveOrderedSet(boolean ... blArray) {
        CommonsLinkedHashSet<Boolean> commonsLinkedHashSet = new CommonsLinkedHashSet<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsLinkedHashSet.add(bl);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Byte> createPrimitiveOrderedSet(byte ... byArray) {
        CommonsLinkedHashSet<Byte> commonsLinkedHashSet = new CommonsLinkedHashSet<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsLinkedHashSet.add(by);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Character> createPrimitiveOrderedSet(char ... cArray) {
        CommonsLinkedHashSet<Character> commonsLinkedHashSet = new CommonsLinkedHashSet<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                commonsLinkedHashSet.add(Character.valueOf(c));
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Double> createPrimitiveOrderedSet(double ... dArray) {
        CommonsLinkedHashSet<Double> commonsLinkedHashSet = new CommonsLinkedHashSet<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                commonsLinkedHashSet.add(d);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Float> createPrimitiveOrderedSet(float ... fArray) {
        CommonsLinkedHashSet<Float> commonsLinkedHashSet = new CommonsLinkedHashSet<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                commonsLinkedHashSet.add(Float.valueOf(f));
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Integer> createPrimitiveOrderedSet(int ... nArray) {
        CommonsLinkedHashSet<Integer> commonsLinkedHashSet = new CommonsLinkedHashSet<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                commonsLinkedHashSet.add(n);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Long> createPrimitiveOrderedSet(long ... lArray) {
        CommonsLinkedHashSet<Long> commonsLinkedHashSet = new CommonsLinkedHashSet<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                commonsLinkedHashSet.add(l);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Short> createPrimitiveOrderedSet(short ... sArray) {
        CommonsLinkedHashSet<Short> commonsLinkedHashSet = new CommonsLinkedHashSet<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                commonsLinkedHashSet.add(s);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Boolean> createPrimitiveSortedSet(boolean ... blArray) {
        CommonsTreeSet<Boolean> commonsTreeSet = new CommonsTreeSet<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsTreeSet.add(bl);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Byte> createPrimitiveSortedSet(byte ... byArray) {
        CommonsTreeSet<Byte> commonsTreeSet = new CommonsTreeSet<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsTreeSet.add(by);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Character> createPrimitiveSortedSet(char ... cArray) {
        CommonsTreeSet<Character> commonsTreeSet = new CommonsTreeSet<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                commonsTreeSet.add(Character.valueOf(c));
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Double> createPrimitiveSortedSet(double ... dArray) {
        CommonsTreeSet<Double> commonsTreeSet = new CommonsTreeSet<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                commonsTreeSet.add(d);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Float> createPrimitiveSortedSet(float ... fArray) {
        CommonsTreeSet<Float> commonsTreeSet = new CommonsTreeSet<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                commonsTreeSet.add(Float.valueOf(f));
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Integer> createPrimitiveSortedSet(int ... nArray) {
        CommonsTreeSet<Integer> commonsTreeSet = new CommonsTreeSet<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                commonsTreeSet.add(n);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Long> createPrimitiveSortedSet(long ... lArray) {
        CommonsTreeSet<Long> commonsTreeSet = new CommonsTreeSet<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                commonsTreeSet.add(l);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Short> createPrimitiveSortedSet(short ... sArray) {
        CommonsTreeSet<Short> commonsTreeSet = new CommonsTreeSet<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                commonsTreeSet.add(s);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Boolean> createPrimitiveStack(boolean ... blArray) {
        NonBlockingStack<Boolean> nonBlockingStack = new NonBlockingStack<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                nonBlockingStack.add(bl);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Byte> createPrimitiveStack(byte ... byArray) {
        NonBlockingStack<Byte> nonBlockingStack = new NonBlockingStack<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                nonBlockingStack.add(by);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Character> createPrimitiveStack(char ... cArray) {
        NonBlockingStack<Character> nonBlockingStack = new NonBlockingStack<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                nonBlockingStack.add(Character.valueOf(c));
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Double> createPrimitiveStack(double ... dArray) {
        NonBlockingStack<Double> nonBlockingStack = new NonBlockingStack<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                nonBlockingStack.add(d);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Float> createPrimitiveStack(float ... fArray) {
        NonBlockingStack<Float> nonBlockingStack = new NonBlockingStack<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                nonBlockingStack.add(Float.valueOf(f));
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Integer> createPrimitiveStack(int ... nArray) {
        NonBlockingStack<Integer> nonBlockingStack = new NonBlockingStack<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                nonBlockingStack.add(n);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Long> createPrimitiveStack(long ... lArray) {
        NonBlockingStack<Long> nonBlockingStack = new NonBlockingStack<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                nonBlockingStack.add(l);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Short> createPrimitiveStack(short ... sArray) {
        NonBlockingStack<Short> nonBlockingStack = new NonBlockingStack<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                nonBlockingStack.add(s);
            }
        }
        return nonBlockingStack;
    }
}

