/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsCollection;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ICommonsList<ELEMENTTYPE>
extends List<ELEMENTTYPE>,
ICommonsCollection<ELEMENTTYPE>,
ICloneable<ICommonsList<ELEMENTTYPE>> {
    @Nonnull
    @ReturnsMutableCopy
    default public <T> ICommonsList<T> createInstance() {
        return new CommonsArrayList();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<ELEMENTTYPE> getAll(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return (ICommonsList)this.getClone();
        }
        ICommonsList iCommonsList = this.createInstance();
        this.findAll(predicate, iCommonsList::add);
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> getAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllMapped(function, iCommonsList::add);
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> getAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllMapped(predicate, function, iCommonsList::add);
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> ICommonsList<DSTTYPE> getAllInstanceOf(@Nonnull Class<DSTTYPE> clazz) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllInstanceOf(clazz, iCommonsList::add);
        return iCommonsList;
    }

    @Nullable
    default public ELEMENTTYPE getFirstOrNull() {
        return this.getFirst(null);
    }

    @Nullable
    default public ELEMENTTYPE getFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(this.isEmpty() ? ELEMENTTYPE : this.get(0));
    }

    @Nullable
    default public ELEMENTTYPE getLastOrNull() {
        return this.getLast(null);
    }

    @Nullable
    default public ELEMENTTYPE getLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        int n = this.size();
        return (ELEMENTTYPE)(n == 0 ? ELEMENTTYPE : this.get(n - 1));
    }

    @Override
    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(n >= 0 && n < this.size() ? this.get(n) : ELEMENTTYPE);
    }

    @Nullable
    default public ELEMENTTYPE setFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.set(0, ELEMENTTYPE);
    }

    @Nullable
    default public ELEMENTTYPE setLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.set(this.size() - 1, ELEMENTTYPE);
    }

    @Nonnull
    default public EChange removeAtIndex(int n) {
        if (n < 0 || n >= this.size()) {
            return EChange.UNCHANGED;
        }
        this.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    default public ELEMENTTYPE removeAndReturnElementAtIndex(int n) {
        return n < 0 || n >= this.size() ? null : (ELEMENTTYPE)this.remove(n);
    }

    @Nullable
    default public ELEMENTTYPE removeFirstOrNull() {
        return this.isEmpty() ? null : (ELEMENTTYPE)this.remove(0);
    }

    @Nullable
    default public ELEMENTTYPE removeLastOrNull() {
        int n = this.size();
        return n == 0 ? null : (ELEMENTTYPE)this.remove(n - 1);
    }

    @Override
    @Nonnull
    @CodingStyleguideUnaware
    default public List<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableList(this);
    }

    @Nonnull
    default public ICommonsList<ELEMENTTYPE> getSortedInline(@Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        this.sort(comparator);
        return this;
    }

    @Nonnull
    default public ICommonsList<ELEMENTTYPE> reverse() {
        Collections.reverse(this);
        return this;
    }

    @Nonnull
    default public ICommonsList<ELEMENTTYPE> swapItems(int n, int n2) {
        if (n != n2) {
            Object e = this.get(n);
            this.set(n, this.get(n2));
            this.set(n2, e);
        }
        return this;
    }
}

