/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.enumeration;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.collection.CollectionHelper;
import com.helger.collection.base.EmptyEnumeration;
import com.helger.collection.enumeration.EnumerationFromIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

@Immutable
public final class EnumerationHelper {
    private EnumerationHelper() {
    }

    public static boolean isEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration == null || !enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration != null && enumeration.hasMoreElements();
    }

    @Nonnegative
    public static int getSize(@Nullable Enumeration<?> enumeration) {
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
        }
        return n;
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ELEMENTTYPEArray == null || ELEMENTTYPEArray.length == 0 ? new EmptyEnumeration() : EnumerationHelper.getEnumeration(Arrays.asList(ELEMENTTYPEArray));
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return CollectionHelper.isEmpty(iterable) ? new EmptyEnumeration() : EnumerationHelper.getEnumeration(iterable.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterator<ELEMENTTYPE> iterator) {
        if (iterator == null) {
            return new EmptyEnumeration();
        }
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Enumeration<Map.Entry<KEYTYPE, VALUETYPE>> getEnumeration(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (map == null) {
            return new EmptyEnumeration<Map.Entry<KEYTYPE, VALUETYPE>>();
        }
        return EnumerationHelper.getEnumeration(map.entrySet());
    }
}

