/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.base;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.base.IIterableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FilterIterator<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aBaseIter;
    private final Predicate<? super ELEMENTTYPE> m_aFilter;
    private ELEMENTTYPE m_aCurrent;
    private boolean m_bHasNext = false;

    public FilterIterator(@NonNull IIterableIterator<? extends ELEMENTTYPE> iIterableIterator, @NonNull Predicate<? super ELEMENTTYPE> predicate) {
        this(iIterableIterator.iterator(), predicate);
    }

    public FilterIterator(@NonNull Iterable<? extends ELEMENTTYPE> iterable, @NonNull Predicate<? super ELEMENTTYPE> predicate) {
        this(iterable.iterator(), predicate);
    }

    public FilterIterator(@NonNull Iterator<? extends ELEMENTTYPE> iterator, @NonNull Predicate<? super ELEMENTTYPE> predicate) {
        this.m_aBaseIter = (Iterator)ValueEnforcer.notNull(iterator, (String)"BaseIterator");
        this.m_aFilter = (Predicate)ValueEnforcer.notNull(predicate, (String)"Filter");
        this._gotoNextCurrent();
    }

    public @NonNull Predicate<? super ELEMENTTYPE> getFilter() {
        return this.m_aFilter;
    }

    private void _gotoNextCurrent() {
        this.m_aCurrent = null;
        this.m_bHasNext = false;
        while (this.m_aBaseIter.hasNext()) {
            ELEMENTTYPE ELEMENTTYPE = this.m_aBaseIter.next();
            if (!this.m_aFilter.test(ELEMENTTYPE)) continue;
            this.m_aCurrent = ELEMENTTYPE;
            this.m_bHasNext = true;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_bHasNext;
    }

    @Override
    public @Nullable ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aCurrent;
        this._gotoNextCurrent();
        return ELEMENTTYPE;
    }

    @Override
    public void remove() {
        this.m_aBaseIter.remove();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseIter", this.m_aBaseIter).append("Filter", this.m_aFilter).getToString();
    }
}

