/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsMap;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CommonsWeakHashMap<KEYTYPE, VALUETYPE>
extends WeakHashMap<KEYTYPE, VALUETYPE>
implements ICommonsMap<KEYTYPE, VALUETYPE> {
    public CommonsWeakHashMap() {
    }

    public CommonsWeakHashMap(@Nonnegative int n) {
        super(n);
    }

    public CommonsWeakHashMap(@Nonnegative int n, @Nonnegative float f) {
        super(n, f);
    }

    public CommonsWeakHashMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(CollectionHelper.getSize(map));
        if (map != null) {
            this.putAll(map);
        }
    }

    public <COLLTYPE> CommonsWeakHashMap(@Nullable COLLTYPE[] COLLTYPEArray, @NonNull Function<? super COLLTYPE, ? extends KEYTYPE> function, @NonNull Function<? super COLLTYPE, ? extends VALUETYPE> function2) {
        super(ArrayHelper.getSize((Object[])COLLTYPEArray));
        this.putAllMapped(COLLTYPEArray, function, function2);
    }

    public <COLLTYPE> CommonsWeakHashMap(@Nullable Collection<? extends COLLTYPE> collection, @NonNull Function<? super COLLTYPE, ? extends KEYTYPE> function, @NonNull Function<? super COLLTYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(collection));
        this.putAllMapped(collection, function, function2);
    }

    public <SRCKEYTYPE, SRCVALUETYPE> CommonsWeakHashMap(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @NonNull Function<? super SRCKEYTYPE, ? extends KEYTYPE> function, @NonNull Function<? super SRCVALUETYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(map));
        this.putAllMapped(map, function, function2);
    }

    @Override
    @ReturnsMutableCopy
    public <K, V> @NonNull CommonsWeakHashMap<K, V> createInstance() {
        return new CommonsWeakHashMap<KEYTYPE, VALUETYPE>();
    }

    @ReturnsMutableCopy
    public @NonNull CommonsWeakHashMap<KEYTYPE, VALUETYPE> getClone() {
        return new CommonsWeakHashMap<KEYTYPE, VALUETYPE>(this);
    }
}

