/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.state.EChange;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CollectionCommonsHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.commons.MapEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsMap<KEYTYPE, VALUETYPE>
extends Map<KEYTYPE, VALUETYPE>,
ICloneable<ICommonsMap<KEYTYPE, VALUETYPE>> {
    @ReturnsMutableCopy
    default public <K, V> @NonNull ICommonsMap<K, V> createInstance() {
        return new CommonsHashMap();
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsSet<KEYTYPE> copyOfKeySet() {
        return new CommonsHashSet(this.keySet());
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsSet<KEYTYPE> copyOfKeySet(@Nullable Predicate<? super KEYTYPE> predicate) {
        if (predicate == null) {
            return this.copyOfKeySet();
        }
        return CommonsHashSet.createFiltered(this.keySet(), predicate);
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<VALUETYPE> copyOfValues() {
        return new CommonsArrayList(this.values());
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<VALUETYPE> copyOfValues(@Nullable Predicate<? super VALUETYPE> predicate) {
        if (predicate == null) {
            return this.copyOfValues();
        }
        return CommonsArrayList.createFiltered(this.values(), predicate);
    }

    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsList<DSTTYPE> copyOfValuesMapped(@NonNull Function<? super VALUETYPE, ? extends DSTTYPE> function) {
        return new CommonsArrayList<DSTTYPE>(this.values(), function);
    }

    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsList<DSTTYPE> copyOfValuesMapped(@Nullable Predicate<? super VALUETYPE> predicate, @NonNull Function<? super VALUETYPE, ? extends DSTTYPE> function) {
        if (predicate == null) {
            return this.copyOfValuesMapped(function);
        }
        return CommonsArrayList.createFiltered(this.values(), predicate, function);
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        CommonsHashSet<int> commonsHashSet = new CommonsHashSet<int>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            commonsHashSet.add(new MapEntry(entry));
        }
        return commonsHashSet;
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public @Nullable Map.Entry<KEYTYPE, VALUETYPE> getFirstEntry() {
        return this.getFirstEntry(null);
    }

    default public @Nullable Map.Entry<KEYTYPE, VALUETYPE> getFirstEntry(@Nullable Map.Entry<KEYTYPE, VALUETYPE> entry) {
        return this.isEmpty() ? entry : this.entrySet().iterator().next();
    }

    default public @Nullable KEYTYPE getFirstKey() {
        return this.getFirstKey(null);
    }

    default public @Nullable KEYTYPE getFirstKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : this.keySet().iterator().next());
    }

    default public @Nullable VALUETYPE getFirstValue() {
        return this.getFirstValue(null);
    }

    default public @Nullable VALUETYPE getFirstValue(@Nullable VALUETYPE VALUETYPE) {
        return (VALUETYPE)(this.isEmpty() ? VALUETYPE : this.values().iterator().next());
    }

    default public @Nullable Map.Entry<KEYTYPE, VALUETYPE> findFirstEntry(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        return CollectionFind.findFirst(this.entrySet(), predicate);
    }

    default public @Nullable KEYTYPE findFirstKey(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        Map.Entry<KEYTYPE, VALUETYPE> entry = this.findFirstEntry(predicate);
        return entry == null ? null : (KEYTYPE)entry.getKey();
    }

    default public @Nullable VALUETYPE findFirstValue(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        Map.Entry<KEYTYPE, VALUETYPE> entry = this.findFirstEntry(predicate);
        return entry == null ? null : (VALUETYPE)entry.getValue();
    }

    default public boolean containsAnyEntry(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        return CollectionFind.containsAny(this.entrySet(), predicate);
    }

    default public boolean containsAnyKey(@Nullable Predicate<? super KEYTYPE> predicate) {
        return CollectionFind.containsAny(this.keySet(), predicate);
    }

    default public boolean containsAnyValue(@Nullable Predicate<? super VALUETYPE> predicate) {
        return CollectionFind.containsAny(this.values(), predicate);
    }

    default public void forEachKey(@NonNull Consumer<? super KEYTYPE> consumer) {
        this.forEach((object, object2) -> consumer.accept((Object)object));
    }

    default public void forEachValue(@NonNull Consumer<? super VALUETYPE> consumer) {
        this.forEach((object, object2) -> consumer.accept((Object)object2));
    }

    default public void forEach(@Nullable BiPredicate<? super KEYTYPE, ? super VALUETYPE> biPredicate, @NonNull BiConsumer<? super KEYTYPE, ? super VALUETYPE> biConsumer) {
        if (biPredicate == null) {
            this.forEach(biConsumer);
        } else {
            this.forEach((object, object2) -> {
                if (biPredicate.test((Object)object, (Object)object2)) {
                    biConsumer.accept((Object)object, (Object)object2);
                }
            });
        }
    }

    default public void forEachKey(@Nullable Predicate<? super KEYTYPE> predicate, @NonNull Consumer<? super KEYTYPE> consumer) {
        if (predicate == null) {
            this.forEachKey(consumer);
        } else {
            this.forEach((object, object2) -> predicate.test((Object)object), (object, object2) -> consumer.accept((Object)object));
        }
    }

    default public void forEachValue(@Nullable Predicate<? super VALUETYPE> predicate, @NonNull Consumer<? super VALUETYPE> consumer) {
        if (predicate == null) {
            this.forEachValue(consumer);
        } else {
            this.forEach((object, object2) -> predicate.test((Object)object2), (object, object2) -> consumer.accept((Object)object2));
        }
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@NonNull Comparator<? super KEYTYPE> comparator) {
        return CollectionCommonsHelper.getSortedByKey(this, comparator);
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@NonNull Comparator<? super VALUETYPE> comparator) {
        return CollectionCommonsHelper.getSortedByValue(this, comparator);
    }

    @ReturnsMutableCopy
    default public @Nullable ICommonsMap<VALUETYPE, KEYTYPE> getSwappedKeyValues() {
        ICommonsMap iCommonsMap = this.createInstance();
        for (Map.Entry entry : this.entrySet()) {
            iCommonsMap.put(entry.getValue(), entry.getKey());
        }
        return iCommonsMap;
    }

    default public @Nullable VALUETYPE put(@NonNull Map.Entry<? extends KEYTYPE, ? extends VALUETYPE> entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    default public void putIf(@NonNull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE, @NonNull Predicate<? super VALUETYPE> predicate) {
        if (predicate.test(VALUETYPE)) {
            this.put(KEYTYPE, VALUETYPE);
        }
    }

    default public void putIfNotNull(@NonNull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        if (VALUETYPE != null) {
            this.put(KEYTYPE, VALUETYPE);
        }
    }

    default public void putAll(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (iterable != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : iterable) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    default public void putAll(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nullable Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        if (map != null) {
            if (predicate == null) {
                this.putAll(map);
            } else {
                for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                    if (!predicate.test(entry)) continue;
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    default public <ELEMENTTYPE> void putAllMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @NonNull Function<? super ELEMENTTYPE, ? extends KEYTYPE> function, @NonNull Function<? super ELEMENTTYPE, ? extends VALUETYPE> function2) {
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                this.put(function.apply(ELEMENTTYPE), function2.apply(ELEMENTTYPE));
            }
        }
    }

    default public <ELEMENTTYPE> void putAllMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @NonNull Function<? super ELEMENTTYPE, ? extends KEYTYPE> function, @NonNull Function<? super ELEMENTTYPE, ? extends VALUETYPE> function2) {
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                this.put(function.apply(ELEMENTTYPE), function2.apply(ELEMENTTYPE));
            }
        }
    }

    default public <SRCKEYTYPE, SRCVALUETYPE> void putAllMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @NonNull Function<? super SRCKEYTYPE, ? extends KEYTYPE> function, @NonNull Function<? super SRCVALUETYPE, ? extends VALUETYPE> function2) {
        if (map != null) {
            for (Map.Entry<SRCKEYTYPE, SRCVALUETYPE> entry : map.entrySet()) {
                this.put(function.apply(entry.getKey()), function2.apply(entry.getValue()));
            }
        }
    }

    default public void putAllIfNotNull(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    default public @NonNull EChange setAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = this.removeAll();
        if (map != null) {
            this.putAll(map);
            if (this.isNotEmpty()) {
                eChange = EChange.CHANGED;
            }
        }
        return eChange;
    }

    default public @NonNull EChange removeAll() {
        if (this.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.clear();
        return EChange.CHANGED;
    }

    default public @NonNull EChange removeObject(@Nullable KEYTYPE KEYTYPE) {
        return EChange.valueOf((this.remove(KEYTYPE) != null ? 1 : 0) != 0);
    }

    default public @NonNull EChange removeIf(@NonNull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        EChange eChange = EChange.UNCHANGED;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    default public @NonNull EChange removeIfKey(@NonNull Predicate<? super KEYTYPE> predicate) {
        return this.removeIf(entry -> predicate.test((Object)entry.getKey()));
    }

    default public @NonNull EChange removeIfValue(@NonNull Predicate<? super VALUETYPE> predicate) {
        return this.removeIf(entry -> predicate.test((Object)entry.getValue()));
    }

    @CodingStyleguideUnaware
    default public @NonNull Map<KEYTYPE, VALUETYPE> getAsUnmodifiable() {
        return Collections.unmodifiableMap(this);
    }
}

