/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.MapEntry;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsOrderedMap<KEYTYPE, VALUETYPE>
extends ICommonsMap<KEYTYPE, VALUETYPE> {
    @Override
    @ReturnsMutableCopy
    default public <K, V> @NonNull ICommonsOrderedMap<K, V> createInstance() {
        return new CommonsLinkedHashMap();
    }

    @Override
    @ReturnsMutableCopy
    default public @NonNull ICommonsOrderedSet<KEYTYPE> copyOfKeySet() {
        return new CommonsLinkedHashSet(this.keySet());
    }

    @Override
    @ReturnsMutableCopy
    default public @NonNull ICommonsOrderedSet<KEYTYPE> copyOfKeySet(@Nullable Predicate<? super KEYTYPE> predicate) {
        if (predicate == null) {
            return this.copyOfKeySet();
        }
        return CommonsLinkedHashSet.createFiltered(this.keySet(), predicate);
    }

    @Override
    @ReturnsMutableCopy
    default public @NonNull ICommonsOrderedSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        CommonsLinkedHashSet<int> commonsLinkedHashSet = new CommonsLinkedHashSet<int>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            commonsLinkedHashSet.add(new MapEntry(entry));
        }
        return commonsLinkedHashSet;
    }

    default public @Nullable KEYTYPE getLastKey() {
        return this.getLastKey(null);
    }

    default public @Nullable KEYTYPE getLastKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : CollectionFind.getLastElement(this.keySet()));
    }

    default public @Nullable VALUETYPE getLastValue() {
        return this.getLastValue(null);
    }

    default public @Nullable VALUETYPE getLastValue(@Nullable VALUETYPE VALUETYPE) {
        KEYTYPE KEYTYPE = this.getLastKey();
        return (VALUETYPE)(KEYTYPE == null ? VALUETYPE : this.get(KEYTYPE));
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<KEYTYPE, VALUETYPE> getClone();
}

