/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.helper;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.equals.EqualsHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.ECollectionBaseType;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.helper.CollectionHelperExt;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class CollectionEqualsHelper {
    private static final CollectionEqualsHelper INSTANCE = new CollectionEqualsHelper();

    private CollectionEqualsHelper() {
    }

    private static boolean _areChildrenEqual(@Nullable Object object, @Nullable Object object2) {
        if (CollectionHelper.isCollectionObject(object) && CollectionHelper.isCollectionObject(object2)) {
            return CollectionEqualsHelper.equalsCollection(object, object2);
        }
        return EqualsHelper.equals((Object)object, (Object)object2);
    }

    public static <T> boolean equalsCollectionOnly(@NonNull Collection<T> collection, @NonNull Collection<?> collection2) {
        if (collection.isEmpty() && collection2.isEmpty()) {
            return true;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<?> iterator = collection2.iterator();
        for (T t : collection) {
            Object obj;
            if (CollectionEqualsHelper._areChildrenEqual(t, obj = iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <K, V> boolean equalsMap(@NonNull Map<K, V> map, @NonNull Map<?, ?> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue();
            if (v == null) {
                if (map2.get(k) == null && map2.containsKey(k)) continue;
                return false;
            }
            if (CollectionEqualsHelper._areChildrenEqual(v, map2.get(k))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equalsSet(@NonNull Set<T> set, @NonNull Set<?> set2) {
        if (set.size() != set2.size()) {
            return false;
        }
        for (T t : set) {
            if (set2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equalsIterator(@NonNull Iterator<T> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            T t = iterator.next();
            if (CollectionEqualsHelper._areChildrenEqual(t, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static <T> boolean equalsEumeration(@NonNull Enumeration<T> enumeration, Enumeration<?> enumeration2) {
        while (enumeration.hasMoreElements()) {
            Object obj;
            if (!enumeration2.hasMoreElements()) {
                return false;
            }
            T t = enumeration.nextElement();
            if (CollectionEqualsHelper._areChildrenEqual(t, obj = enumeration2.nextElement())) continue;
            return false;
        }
        return !enumeration2.hasMoreElements();
    }

    public static boolean equalsCollection(@Nullable Object object, @Nullable Object object2) {
        if (EqualsHelper.identityEqual((Object)object, (Object)object2)) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        ECollectionBaseType eCollectionBaseType = CollectionHelper.getCollectionBaseTypeOfClass(object.getClass());
        ECollectionBaseType eCollectionBaseType2 = CollectionHelper.getCollectionBaseTypeOfClass(object2.getClass());
        if (eCollectionBaseType == null) {
            throw new IllegalArgumentException("The first parameter is not a container type: " + String.valueOf(object));
        }
        if (eCollectionBaseType2 == null) {
            throw new IllegalArgumentException("The second parameter is not a container type: " + String.valueOf(object2));
        }
        if (!eCollectionBaseType.equals((Object)eCollectionBaseType2)) {
            return false;
        }
        switch (eCollectionBaseType) {
            case COLLECTION: {
                Collection collection = (Collection)object;
                Collection collection2 = (Collection)object2;
                return CollectionEqualsHelper.equalsCollectionOnly(collection, collection2);
            }
            case SET: {
                Set set = (Set)object;
                Set set2 = (Set)object2;
                return CollectionEqualsHelper.equalsSet(set, set2);
            }
            case MAP: {
                Map map = (Map)object;
                Map map2 = (Map)object2;
                return CollectionEqualsHelper.equalsMap(map, map2);
            }
            case ARRAY: {
                Class<?> clazz = object.getClass().getComponentType();
                Class<?> clazz2 = object2.getClass().getComponentType();
                if (CollectionHelper.isCollectionClass(clazz) && CollectionHelper.isCollectionClass(clazz2)) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = (Object[])object2;
                    if (objectArray.length != objectArray2.length) {
                        return false;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object3 = objectArray[i];
                        Object object4 = objectArray2[i];
                        if (CollectionEqualsHelper._areChildrenEqual(object3, object4)) continue;
                        return false;
                    }
                    return true;
                }
                return EqualsHelper.equals((Object)object, (Object)object2);
            }
            case ITERATOR: {
                Iterator iterator = (Iterator)object;
                Iterator iterator2 = (Iterator)object2;
                return CollectionEqualsHelper.equalsIterator(iterator, iterator2);
            }
            case ITERABLE: {
                Iterable iterable = (Iterable)object;
                Iterable iterable2 = (Iterable)object2;
                return CollectionEqualsHelper.equalsIterator(iterable.iterator(), iterable2.iterator());
            }
            case ENUMERATION: {
                Enumeration enumeration = (Enumeration)object;
                Enumeration enumeration2 = (Enumeration)object2;
                return CollectionEqualsHelper.equalsEumeration(enumeration, enumeration2);
            }
        }
        throw new IllegalStateException("Unhandled container type " + String.valueOf((Object)eCollectionBaseType) + "!");
    }

    public static boolean equalsAsList(@Nullable Object object, @Nullable Object object2) {
        if (EqualsHelper.identityEqual((Object)object, (Object)object2)) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        CommonsArrayList<?> commonsArrayList = CollectionHelperExt.getAsList(object);
        CommonsArrayList<?> commonsArrayList2 = CollectionHelperExt.getAsList(object2);
        return CollectionEqualsHelper.equalsCollectionOnly(commonsArrayList, commonsArrayList2);
    }
}

