/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.hierarchy;

import com.helger.annotation.Nonnegative;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.hierarchy.IHasChildren;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IHasChildrenSorted<CHILDTYPE>
extends IHasChildren<CHILDTYPE> {
    @Override
    public @Nullable ICommonsList<? extends CHILDTYPE> getAllChildren();

    public @Nullable CHILDTYPE getChildAtIndex(@Nonnegative int var1);

    default public @Nullable CHILDTYPE getFirstChild() {
        return this.getChildAtIndex(0);
    }

    default public @Nullable CHILDTYPE findFirstChild(@NonNull Predicate<? super CHILDTYPE> predicate) {
        if (this.hasNoChildren()) {
            return null;
        }
        return this.getChildren().findFirst(predicate);
    }

    default public <DSTTYPE> @Nullable DSTTYPE findFirstChildMapped(@NonNull Predicate<? super CHILDTYPE> predicate, @NonNull Function<? super CHILDTYPE, ? extends DSTTYPE> function) {
        if (this.hasNoChildren()) {
            return null;
        }
        return this.getChildren().findFirstMapped(predicate, function);
    }

    default public @Nullable CHILDTYPE getLastChild() {
        return this.getChildAtIndex(this.getChildCount() - 1);
    }
}

