/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class SingleElementIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private boolean m_bHasNext = true;
    private final ELEMENTTYPE m_aElement;

    public SingleElementIterator(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_aElement = ELEMENTTYPE;
    }

    @Override
    public boolean hasNext() {
        return this.m_bHasNext;
    }

    @Override
    public @Nullable ELEMENTTYPE next() {
        if (this.m_bHasNext) {
            this.m_bHasNext = false;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementIterator singleElementIterator = (SingleElementIterator)object;
        return this.m_bHasNext == singleElementIterator.m_bHasNext && EqualsHelper.equals(this.m_aElement, singleElementIterator.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bHasNext).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hasNext", this.m_bHasNext).append("element", this.m_aElement).getToString();
    }
}

