/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OffsetDate
implements Temporal,
TemporalAdjuster,
Comparable<OffsetDate>,
Serializable {
    public static final OffsetDate MIN = OffsetDate.of(LocalDate.MIN, ZoneOffset.MAX);
    public static final OffsetDate MAX = OffsetDate.of(LocalDate.MAX, ZoneOffset.MIN);
    private static final long SECONDS_PER_DAY = 86400L;
    private final LocalDate m_aDate;
    private final ZoneOffset m_aOffset;

    @Nonnull
    public static OffsetDate now() {
        return OffsetDate.now(Clock.systemDefaultZone());
    }

    @Nonnull
    public static OffsetDate now(@Nonnull ZoneId zoneId) {
        return OffsetDate.now(Clock.system(zoneId));
    }

    @Nonnull
    public static OffsetDate now(@Nonnull Clock clock) {
        ValueEnforcer.notNull(clock, "clock");
        Instant instant = clock.instant();
        return OffsetDate.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    @Nonnull
    public static OffsetDate of(@Nonnull LocalDate localDate, @Nonnull ZoneOffset zoneOffset) {
        return new OffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static OffsetDate of(int n, int n2, int n3, @Nonnull ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        return new OffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static OffsetDate of(int n, Month month, int n2, @Nonnull ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        return new OffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static OffsetDate ofInstant(@Nonnull Instant instant, @Nonnull ZoneId zoneId) {
        ValueEnforcer.notNull(instant, "instant");
        ValueEnforcer.notNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        long l2 = Math.floorDiv(l, 86400L);
        LocalDate localDate = LocalDate.ofEpochDay(l2);
        return new OffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static OffsetDate from(@Nonnull TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof OffsetDate) {
            return (OffsetDate)temporalAccessor;
        }
        try {
            LocalDate localDate = LocalDate.from(temporalAccessor);
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            return new OffsetDate(localDate, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain OffsetDate from TemporalAccessor: " + temporalAccessor.getClass(), dateTimeException);
        }
    }

    @Nonnull
    public static OffsetDate parse(@Nonnull CharSequence charSequence) {
        return OffsetDate.parse(charSequence, DateTimeFormatter.ISO_OFFSET_DATE);
    }

    @Nonnull
    public static OffsetDate parse(@Nonnull CharSequence charSequence, @Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, OffsetDate::from);
    }

    protected OffsetDate(@Nonnull LocalDate localDate, @Nonnull ZoneOffset zoneOffset) {
        this.m_aDate = ValueEnforcer.notNull(localDate, "date");
        this.m_aOffset = ValueEnforcer.notNull(zoneOffset, "offset");
    }

    private Object readResolve() {
        return OffsetDate.of(this.m_aDate, this.m_aOffset);
    }

    @Nonnull
    private OffsetDate with(@Nonnull LocalDate localDate, @Nonnull ZoneOffset zoneOffset) {
        if (this.m_aDate == localDate && this.m_aOffset.equals(zoneOffset)) {
            return this;
        }
        return new OffsetDate(localDate, zoneOffset);
    }

    @Override
    public boolean isSupported(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isDateBased() || temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(@Nullable TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.m_aDate.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(@Nonnull TemporalField temporalField) {
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this.getOffset().getTotalSeconds();
            }
            return this.m_aDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Nonnull
    public ZoneOffset getOffset() {
        return this.m_aOffset;
    }

    @Nonnull
    public OffsetDate withOffsetSameLocal(@Nonnull ZoneOffset zoneOffset) {
        ValueEnforcer.notNull(zoneOffset, "offset");
        return this.with(this.m_aDate, zoneOffset);
    }

    @Nonnull
    public LocalDate toLocalDate() {
        return this.m_aDate;
    }

    public int getYear() {
        return this.m_aDate.getYear();
    }

    public int getMonthValue() {
        return this.m_aDate.getMonthValue();
    }

    @Nonnull
    public Month getMonth() {
        return this.m_aDate.getMonth();
    }

    public int getDayOfMonth() {
        return this.m_aDate.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.m_aDate.getDayOfYear();
    }

    @Nonnull
    public DayOfWeek getDayOfWeek() {
        return this.m_aDate.getDayOfWeek();
    }

    @Override
    @Nonnull
    public OffsetDate with(@Nonnull TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            return this.with((LocalDate)temporalAdjuster, this.m_aOffset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.with(this.m_aDate, (ZoneOffset)temporalAdjuster);
        }
        if (temporalAdjuster instanceof OffsetDate) {
            return (OffsetDate)temporalAdjuster;
        }
        return (OffsetDate)temporalAdjuster.adjustInto(this);
    }

    @Override
    @Nonnull
    public OffsetDate with(@Nonnull TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                ChronoField chronoField = (ChronoField)temporalField;
                return this.with(this.m_aDate, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
            }
            return this.with(this.m_aDate.with(temporalField, l), this.m_aOffset);
        }
        return temporalField.adjustInto(this, l);
    }

    @Nonnull
    public OffsetDate withYear(int n) {
        return this.with(this.m_aDate.withYear(n), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate withMonth(int n) {
        return this.with(this.m_aDate.withMonth(n), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate withDayOfMonth(int n) {
        return this.with(this.m_aDate.withDayOfMonth(n), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate withDayOfYear(int n) {
        return this.with(this.m_aDate.withDayOfYear(n), this.m_aOffset);
    }

    @Override
    @Nonnull
    public OffsetDate plus(@Nonnull TemporalAmount temporalAmount) {
        return (OffsetDate)temporalAmount.addTo(this);
    }

    @Override
    @Nonnull
    public OffsetDate plus(long l, @Nonnull TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.m_aDate.plus(l, temporalUnit), this.m_aOffset);
        }
        return temporalUnit.addTo(this, l);
    }

    @Nonnull
    public OffsetDate plusYears(long l) {
        return this.with(this.m_aDate.plusYears(l), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate plusMonths(long l) {
        return this.with(this.m_aDate.plusMonths(l), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate plusWeeks(long l) {
        return this.with(this.m_aDate.plusWeeks(l), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate plusDays(long l) {
        return this.with(this.m_aDate.plusDays(l), this.m_aOffset);
    }

    @Override
    @Nonnull
    public OffsetDate minus(@Nonnull TemporalAmount temporalAmount) {
        return (OffsetDate)temporalAmount.subtractFrom(this);
    }

    @Override
    @Nonnull
    public OffsetDate minus(long l, @Nonnull TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    @Nonnull
    public OffsetDate minusYears(long l) {
        return this.with(this.m_aDate.minusYears(l), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate minusMonths(long l) {
        return this.with(this.m_aDate.minusMonths(l), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate minusWeeks(long l) {
        return this.with(this.m_aDate.minusWeeks(l), this.m_aOffset);
    }

    @Nonnull
    public OffsetDate minusDays(long l) {
        return this.with(this.m_aDate.minusDays(l), this.m_aOffset);
    }

    @Override
    public <R> R query(@Nonnull TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.DAYS;
        }
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.getOffset();
        }
        return Temporal.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(@Nonnull Temporal temporal) {
        return temporal.with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds()).with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay());
    }

    @Override
    public long until(@Nonnull Temporal temporal, @Nonnull TemporalUnit temporalUnit) {
        OffsetDate offsetDate = OffsetDate.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = offsetDate.m_aOffset.getTotalSeconds() - this.m_aOffset.getTotalSeconds();
            LocalDate localDate = offsetDate.m_aDate.plusDays(Math.floorDiv(-l, 86400L));
            return this.m_aDate.until(localDate, temporalUnit);
        }
        return temporalUnit.between(this, offsetDate);
    }

    @Nonnull
    public String format(@Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    @Nonnull
    public OffsetDateTime atTime(@Nonnull LocalTime localTime) {
        return OffsetDateTime.of(this.m_aDate, localTime, this.m_aOffset);
    }

    private long toEpochSecond() {
        long l = this.m_aDate.toEpochDay();
        long l2 = l * 86400L;
        return l2 - (long)this.m_aOffset.getTotalSeconds();
    }

    public long toEpochSecond(@Nonnull LocalTime localTime) {
        ValueEnforcer.notNull(localTime, "time");
        return this.toEpochSecond() + (long)localTime.toSecondOfDay();
    }

    @Override
    public int compareTo(@Nonnull OffsetDate offsetDate) {
        if (this.m_aOffset.equals(offsetDate.m_aOffset)) {
            return this.m_aDate.compareTo(offsetDate.m_aDate);
        }
        int n = Long.compare(this.toEpochSecond(), offsetDate.toEpochSecond());
        if (n == 0) {
            n = this.m_aDate.compareTo(offsetDate.m_aDate);
        }
        return n;
    }

    public boolean isAfter(@Nonnull OffsetDate offsetDate) {
        return this.toEpochSecond() > offsetDate.toEpochSecond();
    }

    public boolean isBefore(@Nonnull OffsetDate offsetDate) {
        return this.toEpochSecond() < offsetDate.toEpochSecond();
    }

    public boolean isEqual(@Nonnull OffsetDate offsetDate) {
        return this.toEpochSecond() == offsetDate.toEpochSecond();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        OffsetDate offsetDate = (OffsetDate)object;
        return this.m_aDate.equals(offsetDate.m_aDate) && this.m_aOffset.equals(offsetDate.m_aOffset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aDate).append(this.m_aOffset).getHashCode();
    }

    @Nonnull
    @Nonempty
    public String getAsString() {
        return this.m_aDate.toString() + this.m_aOffset.toString();
    }

    @Deprecated
    public String toString() {
        return new ToStringGenerator(this).append("Date", this.m_aDate).append("Offset", this.m_aOffset).getToString();
    }
}

