/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.datetime.OffsetDate;
import com.helger.commons.datetime.PDTConfig;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTFactory {
    private PDTFactory() {
    }

    @Nonnull
    private static ZoneId _getZoneId() {
        return PDTConfig.getDefaultZoneId();
    }

    public static int getTimezoneOffsetInMinutes(@Nonnull Date date) {
        return -date.getTimezoneOffset();
    }

    public static int getTimezoneOffsetInMinutes(@Nonnull GregorianCalendar gregorianCalendar) {
        long l = gregorianCalendar.getTimeZone().getRawOffset();
        return Math.toIntExact(l / 60000L);
    }

    public static int getTimezoneOffsetInMinutes(@Nonnull ZoneId zoneId, @Nonnull Instant instant) {
        ZoneOffset zoneOffset = zoneId.getRules().getStandardOffset(instant);
        return PDTFactory.getTimezoneOffsetInMinutes(zoneOffset);
    }

    public static int getTimezoneOffsetInMinutes(@Nonnull ZoneOffset zoneOffset) {
        return zoneOffset.getTotalSeconds() / 60;
    }

    @Nonnull
    public static ZoneOffset getZoneOffsetFromOffsetInMinutes(int n) {
        return ZoneOffset.ofHoursMinutes(n / 60, n % 60);
    }

    @Nonnull
    public static ZoneOffset getZoneOffset(@Nonnull Date date) {
        int n = PDTFactory.getTimezoneOffsetInMinutes(date);
        return PDTFactory.getZoneOffsetFromOffsetInMinutes(n);
    }

    @Nonnull
    public static ZoneId getZoneIdFromOffsetInMinutes(int n) {
        ZoneOffset zoneOffset = PDTFactory.getZoneOffsetFromOffsetInMinutes(n);
        return ZoneId.ofOffset("", zoneOffset);
    }

    @Nonnull
    public static ZoneId getZoneId(@Nonnull Date date) {
        int n = PDTFactory.getTimezoneOffsetInMinutes(date);
        return PDTFactory.getZoneIdFromOffsetInMinutes(n);
    }

    @Nonnull
    public static TimeZone getTimeZone(@Nonnull Date date) {
        ZoneId zoneId = PDTFactory.getZoneId(date);
        return TimeZone.getTimeZone(zoneId);
    }

    @Nonnull
    public static ZonedDateTime getCurrentZonedDateTime() {
        return ZonedDateTime.now(PDTFactory._getZoneId());
    }

    @Nonnull
    public static ZonedDateTime getCurrentZonedDateTimeUTC() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    @Nullable
    public static ZonedDateTime getWithMillisOnly(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.withNano(zonedDateTime.get(ChronoField.MILLI_OF_SECOND) * 1000000);
    }

    @Nonnegative
    public static ZonedDateTime getCurrentZonedDateTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentZonedDateTime());
    }

    @Nonnegative
    public static ZonedDateTime getCurrentZonedDateTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentZonedDateTimeUTC());
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toZonedDateTime();
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : ZonedDateTime.of(localDateTime, PDTFactory._getZoneId());
    }

    @Nullable
    public static ZonedDateTime createZonedDateTimeUTC(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : ZonedDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable LocalDate localDate) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(localDate));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTimeUTC(@Nullable LocalDate localDate) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(localDate));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : ZonedDateTime.of(offsetDate.toLocalDate().atStartOfDay(), offsetDate.getOffset());
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(yearMonth));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTimeUTC(@Nullable YearMonth yearMonth) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(yearMonth));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Year year) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(year));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTimeUTC(@Nullable Year year) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(year));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable LocalTime localTime) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(localTime));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTimeUTC(@Nullable LocalTime localTime) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(localTime));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable OffsetTime offsetTime) {
        return PDTFactory.createZonedDateTime(PDTFactory.createOffsetDateTime(offsetTime));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(int n, Month month, int n2) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(n, month, n2));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTimeUTC(int n, Month month, int n2) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(n, month, n2));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTimeUTC(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Instant instant) {
        return instant == null ? null : ZonedDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    @Nullable
    public static ZonedDateTime createZonedDateTimeUTC(@Nullable Instant instant) {
        return instant == null ? null : ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime();
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Date date) {
        return PDTFactory.createZonedDateTime(PDTFactory.createOffsetDateTime(date));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Timestamp timestamp) {
        return PDTFactory.createZonedDateTime(PDTFactory.createOffsetDateTime(timestamp));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(long l) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(l));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTimeUTC(long l) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(l));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(@Nullable Number number) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(number));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTimeUTC(@Nullable Number number) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(number));
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTime() {
        return OffsetDateTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTimeUTC() {
        return OffsetDateTime.now(ZoneOffset.UTC);
    }

    @Nullable
    public static OffsetDateTime getWithMillisOnly(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.withNano(offsetDateTime.get(ChronoField.MILLI_OF_SECOND) * 1000000);
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetDateTime());
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetDateTimeUTC());
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toOffsetDateTime();
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : ZonedDateTime.of(localDateTime, PDTFactory._getZoneId()).toOffsetDateTime();
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTimeUTC(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable LocalDate localDate) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(localDate));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTimeUTC(@Nullable LocalDate localDate) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(localDate));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : OffsetDateTime.of(offsetDate.toLocalDate().atStartOfDay(), offsetDate.getOffset());
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(yearMonth));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTimeUTC(@Nullable YearMonth yearMonth) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(yearMonth));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Year year) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(year));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTimeUTC(@Nullable Year year) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(year));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable LocalTime localTime) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(localTime));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTimeUTC(@Nullable LocalTime localTime) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(localTime));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : offsetTime.atDate(LocalDate.ofEpochDay(0L));
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTime(int n, Month month, int n2) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDate(n, month, n2));
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTimeUTC(int n, Month month, int n2) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDate(n, month, n2));
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTime(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTimeUTC(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Instant instant) {
        return instant == null ? null : OffsetDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTimeUTC(@Nullable Instant instant) {
        return instant == null ? null : OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Date date) {
        return date == null ? null : date.toInstant().atOffset(PDTFactory.getZoneOffset(date));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toInstant().atOffset(PDTFactory.getZoneOffset(timestamp));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : PDTFactory.createOffsetDateTime(gregorianCalendar.toZonedDateTime());
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTime(long l) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(l));
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTimeUTC(long l) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(l));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Number number) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(number));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTimeUTC(@Nullable Number number) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(number));
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTimeUTC() {
        return LocalDateTime.now(ZoneOffset.UTC);
    }

    @Nullable
    public static LocalDateTime getWithMillisOnly(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.withNano(localDateTime.get(ChronoField.MILLI_OF_SECOND) * 1000000);
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalDateTimeUTC());
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable LocalDate localDate) {
        return localDate == null ? null : localDate.atStartOfDay();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createLocalDateTime(PDTFactory.createLocalDate(yearMonth));
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Year year) {
        return PDTFactory.createLocalDateTime(PDTFactory.createLocalDate(year));
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : localTime.atDate(LocalDate.ofEpochDay(0L));
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : PDTFactory.createLocalDateTime(offsetTime.toLocalTime());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, @Nonnull Month month, int n2) {
        return PDTFactory.createLocalDateTime(n, month, n2, 0, 0, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, @Nonnull Month month, int n2, int n3, int n4) {
        return PDTFactory.createLocalDateTime(n, month, n2, n3, n4, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return LocalDateTime.of(n, month, n2, n3, n4, n5);
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Instant instant) {
        return instant == null ? null : LocalDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createLocalDateTime(date.toInstant());
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : PDTFactory.createLocalDateTime(gregorianCalendar.toZonedDateTime());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(long l) {
        return PDTFactory.createLocalDateTime(Instant.ofEpochMilli(l));
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Number number) {
        return number == null ? null : PDTFactory.createLocalDateTime(number.longValue());
    }

    @Nonnegative
    public static LocalDate getCurrentLocalDate() {
        return LocalDate.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static LocalDate getCurrentLocalDateUTC() {
        return LocalDate.now(ZoneOffset.UTC);
    }

    @Nonnull
    public static LocalDate createLocalDate(int n, @Nonnull Month month, int n2) {
        return LocalDate.of(n, month, n2);
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toLocalDate();
    }

    @Nonnull
    public static LocalDate createLocalDate(long l) {
        return PDTFactory.createLocalDateTime(l).toLocalDate();
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createLocalDateTime(instant).toLocalDate();
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable Date date) {
        return date == null ? null : PDTFactory.createLocalDate(date.toInstant());
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : yearMonth.atDay(1);
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable Year year) {
        return year == null ? null : year.atDay(1);
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toLocalDate();
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toLocalDate();
    }

    @Nonnegative
    public static OffsetDate getCurrentOffsetDate() {
        return OffsetDate.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static OffsetDate getCurrentOffsetDateUTC() {
        return OffsetDate.now(ZoneOffset.UTC);
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable LocalDate localDate) {
        return PDTFactory.createOffsetDate(localDate, ZoneOffset.UTC);
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable LocalDate localDate, @Nonnull ZoneOffset zoneOffset) {
        return localDate == null ? null : OffsetDate.of(localDate, zoneOffset);
    }

    @Nonnull
    public static OffsetDate createOffsetDate(int n, @Nonnull Month month, int n2) {
        return PDTFactory.createOffsetDate(n, month, n2, ZoneOffset.UTC);
    }

    @Nonnull
    public static OffsetDate createOffsetDate(int n, @Nonnull Month month, int n2, @Nonnull ZoneOffset zoneOffset) {
        return OffsetDate.of(n, month, n2, zoneOffset);
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : PDTFactory.createOffsetDate(gregorianCalendar.toZonedDateTime());
    }

    @Nonnull
    public static OffsetDate createOffsetDate(long l) {
        return PDTFactory.createOffsetDate(PDTFactory.createOffsetDateTime(l));
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable Instant instant, @Nonnull ZoneOffset zoneOffset) {
        return instant == null ? null : OffsetDate.ofInstant(instant, zoneOffset);
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable Date date) {
        return PDTFactory.createOffsetDate(PDTFactory.createOffsetDateTime(date));
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : PDTFactory.createOffsetDate(yearMonth.atDay(1));
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable Year year) {
        return year == null ? null : PDTFactory.createOffsetDate(year.atDay(1));
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : OffsetDate.of(offsetDateTime.toLocalDate(), offsetDateTime.getOffset());
    }

    @Nullable
    public static OffsetDate createOffsetDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : OffsetDate.of(zonedDateTime.toLocalDate(), zonedDateTime.getOffset());
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTime() {
        return LocalTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTimeUTC() {
        return LocalTime.now(ZoneOffset.UTC);
    }

    @Nullable
    public static LocalTime getWithMillisOnly(@Nullable LocalTime localTime) {
        return localTime == null ? null : localTime.withNano(localTime.get(ChronoField.MILLI_OF_SECOND) * 1000000);
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalTime());
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalTimeUTC());
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toLocalTime();
    }

    @Nonnull
    public static LocalTime createLocalTime(long l) {
        return PDTFactory.createLocalDateTime(l).toLocalTime();
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createLocalDateTime(instant).toLocalTime();
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createLocalTime(date.toInstant());
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : offsetTime.toLocalTime();
    }

    @Nonnull
    public static LocalTime createLocalTime(int n, int n2, int n3) {
        return LocalTime.of(n, n2, n3);
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTime() {
        return OffsetTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTimeUTC() {
        return OffsetTime.now(ZoneOffset.UTC);
    }

    @Nullable
    public static OffsetTime getWithMillisOnly(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : offsetTime.withNano(offsetTime.get(ChronoField.MILLI_OF_SECOND) * 1000000);
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetTime());
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetTimeUTC());
    }

    @Nullable
    public static OffsetTime createOffsetTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toOffsetDateTime().toOffsetTime();
    }

    @Nonnull
    public static OffsetTime createOffsetTime(long l) {
        return PDTFactory.createOffsetDateTime(l).toOffsetTime();
    }

    @Nullable
    public static OffsetTime createOffsetTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createOffsetDateTime(instant).toOffsetTime();
    }

    @Nullable
    public static OffsetTime createOffsetTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createOffsetTime(date.toInstant());
    }

    @Nullable
    public static OffsetTime createOffsetTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toOffsetTime();
    }

    @Nullable
    public static OffsetTime createOffsetTime(@Nullable LocalTime localTime, @Nonnull ZoneOffset zoneOffset) {
        return localTime == null ? null : localTime.atOffset(zoneOffset);
    }

    @Nonnull
    public static OffsetTime createOffsetTime(int n, int n2, int n3, @Nonnull ZoneOffset zoneOffset) {
        return OffsetTime.of(n, n2, n3, 0, zoneOffset);
    }

    @Nullable
    public static Date createDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : Date.from(zonedDateTime.toInstant());
    }

    @Nullable
    public static Date createDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : Date.from(offsetDateTime.toInstant());
    }

    @Nullable
    public static Date createDate(@Nullable LocalDateTime localDateTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localDateTime));
    }

    @Nullable
    public static Date createDate(@Nullable LocalDate localDate) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localDate));
    }

    @Nullable
    public static Date createDate(@Nullable OffsetDate offsetDate) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(offsetDate));
    }

    @Nullable
    public static Date createDate(@Nullable LocalTime localTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localTime));
    }

    @Nullable
    public static Date createDate(@Nullable OffsetTime offsetTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(offsetTime));
    }

    @Nonnull
    public static Date createDateForDate(int n, @Nonnull Month month, int n2) {
        return PDTFactory.createDate(PDTFactory.createLocalDate(n, month, n2));
    }

    @Nonnull
    public static Date createDateForTime(int n, int n2, int n3) {
        return PDTFactory.createDate(PDTFactory.createLocalTime(n, n2, n3));
    }

    @Nonnull
    public static Calendar createCalendar() {
        return Calendar.getInstance(PDTConfig.getDefaultTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnull
    public static Calendar createCalendarUTC() {
        return Calendar.getInstance(PDTConfig.getUTCTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnull
    public static GregorianCalendar createGregorianCalendar() {
        return new GregorianCalendar(PDTConfig.getDefaultTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnull
    public static GregorianCalendar createGregorianCalendarUTC() {
        return new GregorianCalendar(PDTConfig.getUTCTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnegative
    public static int getCurrentYear() {
        return PDTFactory.getCurrentLocalDate().getYear();
    }

    @Nonnegative
    public static int getCurrentYearUTC() {
        return PDTFactory.getCurrentLocalDateUTC().getYear();
    }

    @Nonnull
    public static Year getCurrentYearObj() {
        return Year.now(PDTFactory._getZoneId());
    }

    @Nonnull
    public static Year getCurrentYearObjUTC() {
        return Year.now(ZoneOffset.UTC);
    }

    @Nonnull
    public static MonthDay getCurrentMonthDay() {
        return MonthDay.now(PDTFactory._getZoneId());
    }

    @Nonnull
    public static MonthDay getCurrentMonthDayUTC() {
        return MonthDay.now(ZoneOffset.UTC);
    }

    @Nonnegative
    public static YearMonth getCurrentYearMonth() {
        return YearMonth.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static YearMonth getCurrentYearMonthUTC() {
        return YearMonth.now(ZoneOffset.UTC);
    }

    @Nonnegative
    public static Instant getCurrentInstant() {
        return Instant.now(Clock.system(PDTFactory._getZoneId()));
    }

    @Nonnegative
    public static Instant getCurrentInstantUTC() {
        return Instant.now(Clock.system(ZoneOffset.UTC));
    }

    public static long getCurrentMillis() {
        return PDTFactory.getCurrentInstant().toEpochMilli();
    }

    public static long getCurrentMillisUTC() {
        return PDTFactory.getCurrentInstantUTC().toEpochMilli();
    }

    public static long getMillis(@Nonnull LocalDate localDate) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(localDate));
    }

    public static long getMillis(@Nonnull OffsetDate offsetDate) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(offsetDate));
    }

    public static long getMillis(@Nonnull LocalTime localTime) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(localTime));
    }

    public static long getMillis(@Nonnull OffsetTime offsetTime) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(offsetTime));
    }

    public static long getMillis(@Nonnull LocalDateTime localDateTime) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(localDateTime));
    }

    public static long getMillis(@Nonnull OffsetDateTime offsetDateTime) {
        return offsetDateTime.toInstant().toEpochMilli();
    }

    public static long getMillis(@Nonnull ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }
}

