/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.string.StringParser;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.typeconvert.TypeConverter;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@IsSPIImplementation
@Immutable
public final class DateTimeTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, String.class, calendar -> Long.toString(calendar.getTimeInMillis()));
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Long.class, calendar -> calendar.getTimeInMillis());
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, java.util.Date.class, Calendar::getTime);
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Instant.class, Calendar::toInstant);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, String.class, gregorianCalendar -> Long.toString(gregorianCalendar.getTimeInMillis()));
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, Long.class, gregorianCalendar -> gregorianCalendar.getTimeInMillis());
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, java.util.Date.class, Calendar::getTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, Instant.class, Calendar::toInstant);
        iTypeConverterRegistry.registerTypeConverter(String.class, GregorianCalendar.class, string -> {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
            gregorianCalendar.setTimeInMillis(StringParser.parseLong(string, 0L));
            return gregorianCalendar;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, GregorianCalendar.class, number -> {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
            gregorianCalendar.setTimeInMillis(number.longValue());
            return gregorianCalendar;
        });
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, GregorianCalendar.class, offsetDateTime -> GregorianCalendar.from(offsetDateTime.toZonedDateTime()));
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, GregorianCalendar.class, GregorianCalendar::from);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, Calendar.class, date -> {
            Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
            calendar.setTime((java.util.Date)date);
            return calendar;
        });
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, String.class, date -> Long.toString(date.getTime()));
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, Long.class, date -> date.getTime());
        iTypeConverterRegistry.registerTypeConverter(String.class, java.util.Date.class, string -> new java.util.Date(StringParser.parseLong(string, 0L)));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(java.util.Date.class, java.util.Date::toInstant);
        iTypeConverterRegistry.registerTypeConverter(Month.class, Integer.class, month -> month.getValue());
        iTypeConverterRegistry.registerTypeConverter(DayOfWeek.class, Integer.class, dayOfWeek -> dayOfWeek.getValue());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, java.util.Date.class, number -> new java.util.Date(number.longValue()));
        Function<Number, Instant> function = number -> Instant.ofEpochMilli(number.longValue());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Instant.class, function);
        iTypeConverterRegistry.registerTypeConverter(String.class, Instant.class, Instant::parse);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, Instant.class, java.util.Date::toInstant);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, Instant.class, ChronoZonedDateTime::toInstant);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, Instant.class, OffsetDateTime::toInstant);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, Instant.class, localDateTime -> PDTFactory.createZonedDateTime(localDateTime).toInstant());
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, Instant.class, localDate -> PDTFactory.createZonedDateTime(localDate).toInstant());
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, Instant.class, localTime -> PDTFactory.createZonedDateTime(localTime).toInstant());
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, Instant.class, yearMonth -> PDTFactory.createZonedDateTime(yearMonth).toInstant());
        iTypeConverterRegistry.registerTypeConverter(Year.class, Instant.class, year -> PDTFactory.createZonedDateTime(year).toInstant());
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, ZonedDateTime.class, GregorianCalendar::toZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, ZonedDateTime.class, ZonedDateTime::parse);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, ZonedDateTime.class, OffsetDateTime::toZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(Year.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, OffsetDateTime.class, OffsetDateTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, OffsetDateTime.class, ZonedDateTime::toOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Year.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, LocalDateTime.class, LocalDateTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, LocalDateTime.class, ZonedDateTime::toLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, LocalDateTime.class, OffsetDateTime::toLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(Year.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, LocalDateTime.class, Timestamp::toLocalDateTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, LocalDate.class, gregorianCalendar -> gregorianCalendar.toZonedDateTime().toLocalDate());
        iTypeConverterRegistry.registerTypeConverter(String.class, LocalDate.class, LocalDate::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, LocalDate.class, ZonedDateTime::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, LocalDate.class, OffsetDateTime::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, LocalDate.class, LocalDateTime::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverter(Date.class, LocalDate.class, Date::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverter(Year.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, LocalDate.class, number -> PDTFactory.createLocalDate((Instant)function.apply((Number)number)));
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, LocalTime.class, gregorianCalendar -> gregorianCalendar.toZonedDateTime().toLocalTime());
        iTypeConverterRegistry.registerTypeConverter(String.class, LocalTime.class, LocalTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, LocalTime.class, ZonedDateTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, LocalTime.class, OffsetDateTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, LocalTime.class, LocalDateTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, LocalTime.class, PDTFactory::createLocalTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, LocalTime.class, PDTFactory::createLocalTime);
        iTypeConverterRegistry.registerTypeConverter(Time.class, LocalTime.class, Time::toLocalTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, LocalTime.class, number -> PDTFactory.createLocalTime((Instant)function.apply((Number)number)));
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, GregorianCalendar.class, localDateTime -> GregorianCalendar.from(PDTFactory.createZonedDateTime(localDateTime)));
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, GregorianCalendar.class, localDate -> GregorianCalendar.from(PDTFactory.createZonedDateTime(localDate)));
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, GregorianCalendar.class, localTime -> GregorianCalendar.from(PDTFactory.createZonedDateTime(localTime)));
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, GregorianCalendar.class, yearMonth -> GregorianCalendar.from(PDTFactory.createZonedDateTime(yearMonth)));
        iTypeConverterRegistry.registerTypeConverter(Year.class, GregorianCalendar.class, year -> GregorianCalendar.from(PDTFactory.createZonedDateTime(year)));
        iTypeConverterRegistry.registerTypeConverter(Instant.class, GregorianCalendar.class, instant -> GregorianCalendar.from(PDTFactory.createZonedDateTime(instant)));
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(java.util.Date.class, object -> java.util.Date.from(TypeConverter.convert(object, Instant.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, MonthDay.class, MonthDay::parse);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MonthDay.class, object -> MonthDay.from(TypeConverter.convert(object, LocalDate.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, YearMonth.class, YearMonth::parse);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(YearMonth.class, object -> YearMonth.from(TypeConverter.convert(object, LocalDate.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, Year.class, Year::parse);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Year.class, object -> Year.from(TypeConverter.convert(object, LocalDate.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, Duration.class, Duration::parse);
        iTypeConverterRegistry.registerTypeConverter(String.class, Period.class, Period::parse);
        iTypeConverterRegistry.registerTypeConverter(Integer.class, Month.class, n -> Month.of(n));
        iTypeConverterRegistry.registerTypeConverter(Integer.class, DayOfWeek.class, n -> DayOfWeek.of(n));
    }
}

