/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.map;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.map.AbstractSoftMap;
import com.helger.commons.collection.map.MapEntry;
import com.helger.commons.hashcode.HashCodeGenerator;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class SoftLinkedHashMap<K, V>
extends AbstractSoftMap<K, V> {
    private final int m_nMaxSize;

    public SoftLinkedHashMap(@Nonnegative int n) {
        super(new InternalLinkedHashMap(n));
        this.m_nMaxSize = n;
        ((InternalLinkedHashMap)this.m_aSrcMap).m_aFilter = entry -> {
            int n = this.size();
            if (n <= this.m_nMaxSize) {
                return false;
            }
            this.onRemoveEldestEntry(n, (Map.Entry<K, V>)entry);
            return true;
        };
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull Map.Entry<K, V> entry) {
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public SoftLinkedHashMap<K, V> getClone() {
        SoftLinkedHashMap<K, V> softLinkedHashMap = new SoftLinkedHashMap<K, V>(this.m_nMaxSize);
        softLinkedHashMap.putAll(this);
        return softLinkedHashMap;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SoftLinkedHashMap softLinkedHashMap = (SoftLinkedHashMap)object;
        return this.m_nMaxSize == softLinkedHashMap.m_nMaxSize;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_nMaxSize).getHashCode();
    }

    private static class InternalLinkedHashMap<K, V>
    extends CommonsLinkedHashMap<K, AbstractSoftMap.SoftValue<K, V>> {
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private Predicate<? super Map.Entry<K, V>> m_aFilter;

        public InternalLinkedHashMap(@Nonnegative int n) {
            super(n, 0.75f, true);
        }

        @Override
        protected final boolean removeEldestEntry(@Nonnull Map.Entry<K, AbstractSoftMap.SoftValue<K, V>> entry) {
            MapEntry mapEntry = new MapEntry(entry.getKey(), entry.getValue().get());
            return this.m_aFilter.test(mapEntry);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

