/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.pool;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.log.IHasConditionalLogger;
import com.helger.commons.pool.IMutableObjectPool;
import com.helger.commons.state.ESuccess;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ObjectPool<DATATYPE>
implements IMutableObjectPool<DATATYPE>,
IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectPool.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER, false);
    private final SimpleLock m_aLock = new SimpleLock();
    private final Semaphore m_aAvailable;
    private final Object[] m_aItems;
    private final boolean[] m_aUsed;
    private final Supplier<? extends DATATYPE> m_aFactory;

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    public ObjectPool(@Nonnegative int n, @Nonnull Supplier<? extends DATATYPE> supplier) {
        ValueEnforcer.isGT0(n, "ItemCount");
        ValueEnforcer.notNull(supplier, "Factory");
        this.m_aAvailable = new Semaphore(n);
        this.m_aItems = new Object[n];
        this.m_aUsed = new boolean[n];
        Arrays.fill(this.m_aUsed, 0, n, false);
        this.m_aFactory = supplier;
    }

    @Nonnegative
    public int getPoolSize() {
        return this.m_aItems.length;
    }

    @Nonnegative
    public int getBorrowedObjectCount() {
        return this.m_aItems.length - this.m_aAvailable.availablePermits();
    }

    public void clearUnusedItems() {
        this.m_aLock.lock();
        try {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (this.m_aUsed[i]) continue;
                this.m_aItems[i] = null;
            }
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    @Override
    @Nullable
    public DATATYPE borrowObject() {
        try {
            this.m_aAvailable.acquire();
        }
        catch (InterruptedException interruptedException) {
            CONDLOG.error("ObjectPool interrupted", (Exception)interruptedException);
            Thread.currentThread().interrupt();
            return null;
        }
        this.m_aLock.lock();
        try {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (this.m_aUsed[i]) continue;
                if (this.m_aItems[i] == null) {
                    this.m_aItems[i] = this.m_aFactory.get();
                    if (this.m_aItems[i] == null) {
                        throw new IllegalStateException("The factory returned a null object!");
                    }
                }
                this.m_aUsed[i] = true;
                Object DSTTYPE = GenericReflection.uncheckedCast(this.m_aItems[i]);
                return (DATATYPE)DSTTYPE;
            }
            throw new IllegalStateException("Should never be reached - ObjectPool exceeds its limit. Looks like a programming error.");
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess returnObject(@Nonnull DATATYPE DATATYPE) {
        this.m_aLock.lock();
        try {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (!this.m_aUsed[i] || DATATYPE != this.m_aItems[i]) continue;
                this.m_aUsed[i] = false;
                this.m_aAvailable.release();
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            CONDLOG.warn(() -> "Object " + DATATYPE + " is not pooled!");
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            this.m_aLock.unlock();
        }
    }
}

