/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.format;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.format.IFormatableObject;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FormatableObject<DATATYPE>
implements IFormatableObject<DATATYPE> {
    private final DATATYPE m_aValue;
    private final Function<? super DATATYPE, ? extends String> m_aFormatter;

    public FormatableObject(@Nullable DATATYPE DATATYPE, @Nullable Function<? super DATATYPE, ? extends String> function) {
        this.m_aValue = DATATYPE;
        this.m_aFormatter = function;
    }

    @Override
    @Nullable
    public DATATYPE getValue() {
        return this.m_aValue;
    }

    @Override
    @Nullable
    public Function<? super DATATYPE, ? extends String> getFormatter() {
        return this.m_aFormatter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatableObject formatableObject = (FormatableObject)object;
        return EqualsHelper.equals(this.m_aValue, formatableObject.m_aValue) && EqualsHelper.equals(this.m_aFormatter, formatableObject.m_aFormatter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).append(this.m_aFormatter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).appendIfNotNull("formatter", this.m_aFormatter).getToString();
    }
}

