/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IHasInputStream {
    @Nullable
    public InputStream getInputStream();

    @Nullable
    default public InputStream getBufferedInputStream() {
        return StreamHelper.getBuffered(this.getInputStream());
    }

    @Nullable
    default public <T> T withInputStreamDo(@Nonnull Function<InputStream, T> function) throws IOException {
        ValueEnforcer.notNull(function, "Func");
        try (InputStream inputStream = this.getInputStream();){
            T t = function.apply(inputStream);
            return t;
        }
    }

    @Nullable
    default public <T> T withBufferedInputStreamDo(@Nonnull Function<InputStream, T> function) throws IOException {
        ValueEnforcer.notNull(function, "Func");
        try (InputStream inputStream = this.getBufferedInputStream();){
            T t = function.apply(inputStream);
            return t;
        }
    }

    public boolean isReadMultiple();
}

