/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.io.file.EFileIOErrorCode;
import com.helger.commons.io.file.EFileIOOperation;
import com.helger.commons.io.file.IFileOperationCallback;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFileOperationCallback
implements IFileOperationCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFileOperationCallback.class);

    @Override
    public void onSuccess(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull File file, @Nullable File file2) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File operation " + eFileIOOperation.name() + " succeeded on '" + String.valueOf(file) + "'" + (String)(file2 == null ? "" : " and '" + String.valueOf(file2) + "'"));
        }
    }

    @Override
    public void onError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull File file, @Nullable File file2, @Nullable Exception exception) {
        LOGGER.warn("File operation " + eFileIOOperation.name() + " failed with error code " + eFileIOErrorCode.name() + " on '" + String.valueOf(file) + "'" + (String)(file2 == null ? "" : " and '" + String.valueOf(file2) + "'"), (Throwable)exception);
    }
}

