/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.util.TextVariableHelper;
import com.helger.config.IConfig;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.value.ConfiguredValue;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.config.value.IConfigurationValueProviderWithPriorityCallback;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
implements IConfig {
    public static final boolean DEFAULT_REPLACE_VARIABLES = false;
    public static final UnaryOperator<String> DEFAULT_UNRESOLVED_VARIABLE_PROVIDER = string -> "unresolved-var(" + string + ")";
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    private final IConfigurationValueProvider m_aValueProvider;
    private BiConsumer<String, ConfiguredValue> m_aKeyFoundConsumer;
    private Consumer<String> m_aKeyNotFoundConsumer;
    private boolean m_bReplaceVariables = false;
    private UnaryOperator<String> m_aUnresolvedVariableProvider = DEFAULT_UNRESOLVED_VARIABLE_PROVIDER;

    public Config(@Nonnull IConfigurationValueProvider iConfigurationValueProvider) {
        ValueEnforcer.notNull((Object)iConfigurationValueProvider, (String)"ValueProvider");
        this.m_aValueProvider = iConfigurationValueProvider;
    }

    @Nonnull
    public final IConfigurationValueProvider getConfigurationValueProvider() {
        return this.m_aValueProvider;
    }

    @Nullable
    public final BiConsumer<String, ConfiguredValue> getFoundKeyConsumer() {
        return this.m_aKeyFoundConsumer;
    }

    @Nullable
    public final Config setFoundKeyConsumer(@Nullable BiConsumer<String, ConfiguredValue> biConsumer) {
        this.m_aKeyFoundConsumer = biConsumer;
        return this;
    }

    @Nullable
    public final Consumer<String> getKeyNotFoundConsumer() {
        return this.m_aKeyNotFoundConsumer;
    }

    @Nullable
    public final Config setKeyNotFoundConsumer(@Nullable Consumer<String> consumer) {
        this.m_aKeyNotFoundConsumer = consumer;
        return this;
    }

    public final boolean isReplaceVariables() {
        return this.m_bReplaceVariables;
    }

    @Nonnull
    public final Config setReplaceVariables(boolean bl) {
        this.m_bReplaceVariables = bl;
        return this;
    }

    @Nonnull
    public final UnaryOperator<String> getUnresolvedVariableProvider() {
        return this.m_aUnresolvedVariableProvider;
    }

    @Nonnull
    public final Config setUnresolvedVariableProvider(@Nonnull UnaryOperator<String> unaryOperator) {
        ValueEnforcer.notNull(unaryOperator, (String)"UnresolvedVariableProvider");
        this.m_aUnresolvedVariableProvider = unaryOperator;
        return this;
    }

    @Override
    @Nullable
    public ConfiguredValue getConfiguredValue(@Nullable String string) {
        ConfiguredValue configuredValue = StringHelper.hasNoText((String)string) ? null : this.m_aValueProvider.getConfigurationValue(string);
        if (configuredValue != null) {
            if (this.m_aKeyFoundConsumer != null) {
                this.m_aKeyFoundConsumer.accept(string, configuredValue);
            }
        } else if (this.m_aKeyNotFoundConsumer != null) {
            this.m_aKeyNotFoundConsumer.accept(string);
        }
        return configuredValue;
    }

    @Nonnull
    @Nonempty
    private String _getWithVariablesReplacedRecursive(@Nonnull @Nonempty String string, @Nonnull ICommonsSet<String> iCommonsSet) {
        UnaryOperator unaryOperator = string2 -> {
            if (!iCommonsSet.add(string2)) {
                throw new IllegalStateException("Found a variable cyclic dependency: " + StringHelper.imploder().source((Iterable)iCommonsSet, string -> '\"' + string + '\"').separator(" -> ").build() + " -> \"" + string2 + '\"');
            }
            ConfiguredValue configuredValue = this.getConfiguredValue((String)string2);
            if (configuredValue == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to resolve configuration variable '" + string2 + "'");
                }
                return (String)this.m_aUnresolvedVariableProvider.apply((String)string2);
            }
            String string3 = configuredValue.getValue();
            if (StringHelper.hasText((String)string3)) {
                string3 = this._getWithVariablesReplacedRecursive(string3, iCommonsSet);
            }
            iCommonsSet.remove(string2);
            return string3;
        };
        return TextVariableHelper.getWithReplacedVariables((String)string, (UnaryOperator)unaryOperator);
    }

    @Nullable
    public String getValue(@Nullable String string) {
        String string2;
        block5: {
            ConfiguredValue configuredValue = this.getConfiguredValue(string);
            if (configuredValue == null) {
                return null;
            }
            string2 = configuredValue.getValue();
            if (this.m_bReplaceVariables && StringHelper.hasText((String)string2)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolving variables in configuration value '" + string2 + "'");
                }
                try {
                    string2 = this._getWithVariablesReplacedRecursive(string2, (ICommonsSet<String>)new CommonsLinkedHashSet());
                }
                catch (IllegalStateException illegalStateException) {
                    if (!LOGGER.isErrorEnabled()) break block5;
                    LOGGER.error("Failed to replace variables in configuration value '" + string2 + "': " + illegalStateException.getMessage());
                }
            }
        }
        return string2;
    }

    private static void _forEachConfigurationValueProviderRecursive(@Nonnull IConfigurationValueProvider iConfigurationValueProvider2, int n2, @Nonnull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        if (iConfigurationValueProvider2 instanceof MultiConfigurationValueProvider) {
            MultiConfigurationValueProvider multiConfigurationValueProvider = (MultiConfigurationValueProvider)iConfigurationValueProvider2;
            multiConfigurationValueProvider.forEachConfigurationValueProvider((iConfigurationValueProvider, n) -> Config._forEachConfigurationValueProviderRecursive(iConfigurationValueProvider, n, iConfigurationValueProviderWithPriorityCallback));
        } else {
            int n3 = n2;
            if (n3 < 0 && iConfigurationValueProvider2 instanceof IConfigurationSource) {
                IConfigurationSource iConfigurationSource = (IConfigurationSource)iConfigurationValueProvider2;
                n3 = iConfigurationSource.getPriority();
            }
            iConfigurationValueProviderWithPriorityCallback.onConfigurationSource(iConfigurationValueProvider2, n3);
        }
    }

    public static void forEachConfigurationValueProviderRecursive(@Nonnull IConfigurationValueProvider iConfigurationValueProvider, @Nonnull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        Config._forEachConfigurationValueProviderRecursive(iConfigurationValueProvider, -1, iConfigurationValueProviderWithPriorityCallback);
    }

    @Override
    public void forEachConfigurationValueProvider(@Nonnull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        ValueEnforcer.notNull((Object)iConfigurationValueProviderWithPriorityCallback, (String)"Callback");
        Config.forEachConfigurationValueProviderRecursive(this.m_aValueProvider, iConfigurationValueProviderWithPriorityCallback);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ValueProvider", (Object)this.m_aValueProvider).append("KeyFoundConsumer", this.m_aKeyFoundConsumer).append("KeyNotFoundConsumer", this.m_aKeyNotFoundConsumer).append("ReplaceVariables", this.m_bReplaceVariables).append("UnresolvedVariableProvider", this.m_aUnresolvedVariableProvider).getToString();
    }

    @Nonnull
    public static Config create(@Nonnull IConfigurationValueProvider iConfigurationValueProvider) {
        return new Config(iConfigurationValueProvider);
    }
}

