/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.annotation.concurrent.Immutable;
import com.helger.datetime.format.EDTFormatterMode;
import com.helger.datetime.format.PDTFormatter;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;

@Immutable
public final class PDTToString {
    private static final PDTToString INSTANCE = new PDTToString();

    private PDTToString() {
    }

    @Nullable
    public static String getAsString(@Nullable LocalDate localDate, @Nonnull Locale locale) {
        return localDate == null ? null : PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDate);
    }

    @Nullable
    public static String getAsString(@Nullable OffsetDate offsetDate, @Nonnull Locale locale) {
        return offsetDate == null ? null : PDTFormatter.getFormatterOffsetDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetDate);
    }

    @Nullable
    public static String getAsString(@Nullable XMLOffsetDate xMLOffsetDate, @Nonnull Locale locale) {
        if (xMLOffsetDate == null) {
            return null;
        }
        if (xMLOffsetDate.hasOffset()) {
            return PDTFormatter.getFormatterOffsetDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDate);
        }
        return PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDate.toLocalDate());
    }

    @Nullable
    public static String getAsString(@Nullable LocalTime localTime, @Nonnull Locale locale) {
        return localTime == null ? null : PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localTime);
    }

    @Nullable
    public static String getAsString(@Nullable OffsetTime offsetTime, @Nonnull Locale locale) {
        return offsetTime == null ? null : PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetTime);
    }

    @Nullable
    public static String getAsString(@Nullable XMLOffsetTime xMLOffsetTime, @Nonnull Locale locale) {
        if (xMLOffsetTime == null) {
            return null;
        }
        if (xMLOffsetTime.hasOffset()) {
            return PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetTime);
        }
        return PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetTime.toLocalTime());
    }

    @Nullable
    public static String getAsString(@Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        return localDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable ZonedDateTime zonedDateTime, @Nonnull Locale locale) {
        return zonedDateTime == null ? null : PDTFormatter.getFormatterZonedDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(zonedDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable OffsetDateTime offsetDateTime, @Nonnull Locale locale) {
        return offsetDateTime == null ? null : PDTFormatter.getFormatterOffsetDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable XMLOffsetDateTime xMLOffsetDateTime, @Nonnull Locale locale) {
        if (xMLOffsetDateTime == null) {
            return null;
        }
        if (xMLOffsetDateTime.hasOffset()) {
            return PDTFormatter.getFormatterOffsetDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDateTime);
        }
        return PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDateTime.toLocalDateTime());
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable TemporalAccessor temporalAccessor) {
        return PDTToString.getAsString(string, temporalAccessor, null);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable TemporalAccessor temporalAccessor, @Nullable Locale locale) {
        return temporalAccessor == null ? null : PDTFormatter.getForPattern(string, locale).format(temporalAccessor);
    }
}

