/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.inmemory;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.bytes.ByteArrayWrapper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasByteArray;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.inmemory.AbstractMemoryReadableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.Arrays;

public class ReadableResourceByteArray
extends AbstractMemoryReadableResource
implements IHasByteArray {
    public static final boolean DEFAULT_COPY_NEEDED = true;
    private final ByteArrayWrapper m_aBytes;

    public ReadableResourceByteArray(@Nonnull byte[] byArray) {
        this(null, byArray, true);
    }

    public ReadableResourceByteArray(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(null, byArray, n, n2, true);
    }

    public ReadableResourceByteArray(@Nonnull byte[] byArray, boolean bl) {
        this((String)null, byArray, bl);
    }

    public ReadableResourceByteArray(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        this(null, byArray, n, n2, bl);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray) {
        this(string, byArray, true);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(string, byArray, n, n2, true);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray, boolean bl) {
        this(string, byArray, 0, byArray.length, bl);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        super((String)(StringHelper.isNotEmpty((String)string) ? string : "bytes-" + n2 + "-" + Arrays.hashCode(byArray)));
        ValueEnforcer.isArrayOfsLen((byte[])byArray, (int)n, (int)n2);
        this.m_aBytes = new ByteArrayWrapper(byArray, n, n2, bl);
    }

    public final boolean isCopy() {
        return this.m_aBytes.isCopy();
    }

    @Nonnull
    @ReturnsMutableObject
    public final byte[] bytes() {
        return this.m_aBytes.bytes();
    }

    @Nonnegative
    public int getOffset() {
        return this.m_aBytes.getOffset();
    }

    @Nonnegative
    public final int size() {
        return this.m_aBytes.size();
    }

    public boolean isEmpty() {
        return this.m_aBytes.isEmpty();
    }

    @Nonnull
    public InputStream getInputStream() {
        return this.m_aBytes.getInputStream();
    }

    public boolean isReadMultiple() {
        return this.m_aBytes.isReadMultiple();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Bytes", (Object)this.m_aBytes).getToString();
    }
}

